/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.sonoair;

import eu.mihosoft.vrl.base.ConfigurationFile;
import eu.mihosoft.vrl.base.IOUtil;
import eu.mihosoft.vrl.base.VRL;
import java.io.File;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;

public class ConfigController {
    public static final String KEY_NEW_DISCOVERY = "sonoair:discovery-method:new";
    public static final String KEY_OLD_DISCOVERY = "sonoair:discovery-method:old";
    public static final String KEY_DISCOVERY_TIMEOUT = "sonoair:discovery-timeout";
    public static final String KEY_ENABLE_DEBUG = "sonoair:enable-debug";
    private final BooleanProperty newDiscoveryMethodProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty oldDiscoveryMethodProperty = new SimpleBooleanProperty(false);
    private final LongProperty discoveryTimeoutProperty = new SimpleLongProperty(10000L);
    private final BooleanProperty enableDebugProperty = new SimpleBooleanProperty(false);
    private final File configFile = new File(VRL.getPropertyFolderManager().getConfigFolder(), "config.xml");
    private final ConfigurationFile config = IOUtil.newConfigurationFile(this.configFile);

    public ConfigController() {
        if (!this.config.load()) {
            System.err.println(">> WARNING: cannot load config file " + this.configFile);
        }
        this.initListeners();
    }

    private void initListeners() {
        this.getNewDiscoveryMethodProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_NEW_DISCOVERY, newV.toString());
            this.config.save();
        });
        this.getOldDiscoveryMethodProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_OLD_DISCOVERY, newV.toString());
            this.config.save();
        });
        this.getDiscoveryTimeoutProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_DISCOVERY_TIMEOUT, newV.toString());
            this.config.save();
        });
        this.getEnableDebugProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_ENABLE_DEBUG, newV.toString());
            this.config.save();
        });
    }

    public void loadConfig() {
        String newDiscoveryRbState = this.config.getProperty(KEY_NEW_DISCOVERY).orElse("" + this.getNewDiscoveryMethodProperty().get());
        this.getNewDiscoveryMethodProperty().set(Boolean.valueOf(newDiscoveryRbState).booleanValue());
        String oldDiscoveryRbState = this.config.getProperty(KEY_OLD_DISCOVERY).orElse("" + this.getOldDiscoveryMethodProperty().get());
        this.getOldDiscoveryMethodProperty().set(Boolean.valueOf(oldDiscoveryRbState).booleanValue());
        String enableDebugOutputCbState = this.config.getProperty(KEY_ENABLE_DEBUG).orElse("" + this.getEnableDebugProperty().get());
        this.getEnableDebugProperty().set(Boolean.valueOf(enableDebugOutputCbState).booleanValue());
        String discoveryTimeoutTfState = this.config.getProperty(KEY_DISCOVERY_TIMEOUT).orElse("" + this.getDiscoveryTimeoutProperty().get());
        this.getDiscoveryTimeoutProperty().set(Long.valueOf(discoveryTimeoutTfState).longValue());
    }

    public BooleanProperty getNewDiscoveryMethodProperty() {
        return this.newDiscoveryMethodProperty;
    }

    public BooleanProperty getOldDiscoveryMethodProperty() {
        return this.oldDiscoveryMethodProperty;
    }

    public LongProperty getDiscoveryTimeoutProperty() {
        return this.discoveryTimeoutProperty;
    }

    public BooleanProperty getEnableDebugProperty() {
        return this.enableDebugProperty;
    }
}

