/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.sonoair;

import eu.mihosoft.sonoair.ConfigController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.LongStringConverter;

public class PreferencesController
implements Initializable {
    private ConfigController configController;
    @FXML
    RadioButton newDiscoveryRb;
    @FXML
    RadioButton oldDiscoveryRb;
    @FXML
    TextField timeoutTf;
    @FXML
    CheckBox enableDebugOutputCb;

    public void initialize(URL url, ResourceBundle rb) {
        this.setupTextFields();
    }

    public void setConfigController(ConfigController configController) {
        this.configController = configController;
        LongStringConverter converter = new LongStringConverter();
        this.newDiscoveryRb.selectedProperty().bindBidirectional((Property)configController.getNewDiscoveryMethodProperty());
        this.oldDiscoveryRb.selectedProperty().bindBidirectional((Property)configController.getOldDiscoveryMethodProperty());
        this.timeoutTf.textProperty().bindBidirectional((Property)configController.getDiscoveryTimeoutProperty(), (StringConverter)converter);
        this.enableDebugOutputCb.selectedProperty().bindBidirectional((Property)configController.getEnableDebugProperty());
    }

    private void setupTextFields() {
        this.timeoutTf.textProperty().addListener((ov, oldV, newV) -> {
            boolean isDigit = true;
            boolean invalid = false;
            for (int i = 0; i < newV.length(); ++i) {
                char ch = newV.charAt(i);
                boolean bl = isDigit = ch >= '0' && ch <= '9';
                if (isDigit) continue;
                invalid = true;
            }
            if (invalid) {
                this.timeoutTf.setText(oldV);
            } else if (newV.length() > 5) {
                this.timeoutTf.setText(newV.substring(0, 5));
            }
        });
        this.timeoutTf.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){
            private String numericLastKey;

            public void handle(KeyEvent event) {
                boolean isDigit;
                char[] ar = event.getCharacter().toCharArray();
                char ch = ar[ar.length - 1];
                boolean bl = isDigit = ch >= '0' && ch <= '9';
                if (isDigit) {
                    this.numericLastKey = String.valueOf(ch);
                }
                if (this.isValid()) {
                    if (!isDigit) {
                        event.consume();
                    }
                } else {
                    event.consume();
                }
            }

            private boolean isValid() {
                if (PreferencesController.this.timeoutTf.getText().isEmpty()) {
                    return true;
                }
                try {
                    String testText = PreferencesController.this.timeoutTf.getText();
                    testText = this.numericLastKey != null && !this.numericLastKey.isEmpty() ? testText + this.numericLastKey : testText;
                    this.numericLastKey = "";
                    Integer.parseInt(testText);
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                return true;
            }
        });
    }
}

