/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.sonoair;

import eu.mihosoft.sonoair.OutputFilter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.TextArea;

public class RedirectableStream
extends PrintStream {
    public static PrintStream ORIGINAL_SOUT = System.out;
    public static PrintStream ORIGINAL_SERR = System.err;
    private final List<TextArea> views = new ArrayList<TextArea>();
    private boolean redirectToUi;
    private boolean redirectToStdOut;
    private final List<OutputFilter> filters = new ArrayList<OutputFilter>();

    public RedirectableStream(OutputStream out, TextArea ... views) {
        super(out);
        this.views.clear();
        for (TextArea textArea : views) {
            this.addView(textArea);
        }
        this.setRedirectToStdOut(true);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) {
        if (this.isRedirectToUi()) {
            RedirectableStream.invokeAndWait(() -> {
                int i = 0;
                for (TextArea view : this.views) {
                    String s = new String(buf, off, len);
                    if (this.filters.get(i).onMatch(s)) {
                        try {
                            int startOffSet = view.getText().length();
                            view.insertText(startOffSet, s);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            });
        }
        if (this.isRedirectToStdOut()) {
            super.write(buf, off, len);
        }
    }

    public final void addView(TextArea view) {
        this.views.add(view);
        this.filters.add(s -> true);
    }

    public void setFilter(TextArea view, OutputFilter filter) {
        int i = this.views.indexOf(view);
        this.filters.set(i, filter);
    }

    public boolean isRedirectToUi() {
        return this.redirectToUi;
    }

    public void setRedirectToUi(boolean redirectToUi) {
        this.redirectToUi = redirectToUi;
    }

    public boolean isRedirectToStdOut() {
        return this.redirectToStdOut;
    }

    public final void setRedirectToStdOut(boolean redirectToStdOut) {
        this.redirectToStdOut = redirectToStdOut;
    }

    private static void invokeAndWait(Runnable r) {
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            FutureTask<Boolean> task = new FutureTask<Boolean>(r, true);
            Platform.runLater(task);
            try {
                task.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(RedirectableStream.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

