/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.sonoair;

import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.tk.Toolkit;
import eu.mihosoft.sonoair.ConfigController;
import eu.mihosoft.sonoair.PreferencesController;
import eu.mihosoft.sonoair.RedirectableStream;
import eu.mihosoft.sonoair.ZoneGroupWrapper;
import eu.mihosoft.upnp.sonos.ZoneGroup;
import eu.mihosoft.upnp.sonos.ZonePlayer;
import eu.mihosoft.upnp.sonos.ZonePlayers;
import eu.mihosoft.vrl.base.VJarUtil;
import eu.mihosoft.vrl.base.VRL;
import eu.mihosoft.vrl.base.VSysUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class SonoAir
extends Application {
    public static final String VERSION_TEXT = "1.0 (BETA 4.0)";
    public static final String VERSION_CONFIG_PATH = "1.0-beta-4.0";
    private ConfigController configController;
    private File baseDir;
    private ListView<ZoneGroupWrapper> deviceView;
    private Stage primaryStage;
    private RedirectableStream outStream;
    private TextArea outputArea;
    private StringProperty btnTextProperty;
    private StringProperty windowTitleProperty;
    private DoubleProperty dividerProperty;
    private volatile ZonePlayers zonePlayers;
    private volatile String devices = "";
    private volatile List<ZoneGroup> payerGroups;
    private volatile int retryCounter;
    private Process process;

    public void start(Stage primaryStage) {
        SplitPane root = this.initMainUI(primaryStage);
        this.initMenus();
        this.initSceneAndStage(root, primaryStage);
        VRL.init();
        this.initConfigController();
        this.rescanAndReRunAirSonos();
    }

    private void initConfigController() {
        this.configController = new ConfigController();
        this.configController.getEnableDebugProperty().addListener(ov -> {
            if (this.configController.getEnableDebugProperty().get()) {
                System.setErr(this.outStream);
            } else {
                System.setErr(RedirectableStream.ORIGINAL_SERR);
            }
        });
        this.configController.loadConfig();
        if (this.configController.getEnableDebugProperty().get()) {
            System.setErr(this.outStream);
        } else {
            System.setErr(RedirectableStream.ORIGINAL_SERR);
        }
    }

    private SplitPane initMainUI(Stage primaryStage1) {
        this.outputArea = new TextArea();
        this.outputArea.setMinHeight(0.0);
        this.outputArea.getStyleClass().add((Object)"output");
        this.outputArea.setWrapText(true);
        this.outStream = new RedirectableStream((OutputStream)System.out, this.outputArea);
        this.outStream.setRedirectToStdOut(true);
        this.outStream.setRedirectToUi(true);
        this.deviceView = new ListView();
        this.deviceView.setCellFactory(param -> {
            ListCell<ZoneGroupWrapper> cell = new ListCell<ZoneGroupWrapper>(){
                StackPane pane = new StackPane();
                Label label = new Label();
                Button editBtn = new Button("\uf013");
                {
                    this.label.getStyleClass().add((Object)"device-label");
                    this.pane.getChildren().addAll((Object[])new Node[]{this.label, this.editBtn});
                    this.setOnMouseClicked(me -> {
                        if (me.getClickCount() == 2 && me.getButton() == MouseButton.PRIMARY && !this.getText().trim().isEmpty()) {
                            SonoAir.this.openControlView((Node)this, ((ZoneGroupWrapper)this.getItem()).getGroup());
                        }
                    });
                    this.editBtn.setOnAction(ae -> SonoAir.this.openControlView((Node)this, ((ZoneGroupWrapper)this.getItem()).getGroup()));
                    this.editBtn.setFont(Font.loadFont((String)SonoAir.class.getResource("/font/fontawesome-webfont.ttf").toExternalForm(), (double)14.0));
                    StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER);
                    StackPane.setAlignment((Node)this.editBtn, (Pos)Pos.CENTER_RIGHT);
                }

                protected void updateItem(ZoneGroupWrapper item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setText(null);
                    if (empty || item == null || item.toString().isEmpty()) {
                        this.setGraphic(null);
                    } else {
                        this.setGraphic((Node)this.pane);
                    }
                    if (item != null) {
                        this.label.setText(item.toString());
                        this.editBtn.setDisable(item.getGroup() == null);
                    }
                }
            };
            cell.setAlignment(Pos.CENTER);
            return cell;
        });
        Label label = new Label("Devices:");
        label.getStyleClass().add((Object)"title");
        label.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER);
        Button donateButton = new Button();
        donateButton.getStyleClass().add((Object)"paypal-donate-btn");
        donateButton.setMinWidth(120.0);
        donateButton.setMinHeight(40.0);
        donateButton.setOnAction(e -> this.showDonationPage());
        BorderPane mainUI = new BorderPane();
        StackPane p = new StackPane(new Node[]{donateButton});
        AnchorPane.setTopAnchor((Node)p, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)p, (Double)0.0);
        AnchorPane aPane = new AnchorPane(new Node[]{label, p});
        StackPane.setAlignment((Node)donateButton, (Pos)Pos.CENTER);
        AnchorPane.setLeftAnchor((Node)label, (Double)0.0);
        AnchorPane.setRightAnchor((Node)label, (Double)0.0);
        mainUI.setTop((Node)aPane);
        mainUI.getStyleClass().add((Object)"background");
        mainUI.setSnapToPixel(true);
        mainUI.setCenter(this.deviceView);
        Button btn = new Button();
        this.btnTextProperty = btn.textProperty();
        btn.getStyleClass().add((Object)"restart-btn");
        btn.setText("Stop SonoAir");
        btn.setOnAction(event -> {
            if (!this.isAirsonosRunning()) {
                this.btnTextProperty.set((Object)"Stop SonoAir");
                this.updateDeviceView();
                primaryStage1.setTitle("SonoAir v1.0 (BETA 4.0)");
                this.rescanAndReRunAirSonos();
            } else {
                this.btnTextProperty.set((Object)"Start SonoAir");
                this.stopAirSonos();
            }
        });
        StackPane btnPane = new StackPane(new Node[]{btn});
        BorderPane.setAlignment((Node)btnPane, (Pos)Pos.CENTER);
        btnPane.getStyleClass().add((Object)"btn-pane");
        mainUI.setBottom((Node)btnPane);
        mainUI.setMinHeight(215.0);
        SplitPane root = new SplitPane();
        root.getStyleClass().add((Object)"split-pane");
        root.setOrientation(Orientation.VERTICAL);
        root.getItems().addAll((Object[])new Node[]{mainUI, this.outputArea});
        root.setDividerPositions(new double[]{1.0});
        this.dividerProperty = ((SplitPane.Divider)root.getDividers().get(0)).positionProperty();
        return root;
    }

    private void initSceneAndStage(SplitPane root, Stage primaryStage1) {
        Scene scene = new Scene((Parent)root, 650.0, 400.0);
        scene.getStylesheets().add((Object)"/eu/mihosoft/sonoair/maininterface.css");
        this.baseDir = VJarUtil.getClassLocation(SonoAir.class).getAbsoluteFile().getParentFile();
        this.primaryStage = primaryStage1;
        this.windowTitleProperty = primaryStage1.titleProperty();
        this.windowTitleProperty.set((Object)"SonoAir v1.0 (BETA 4.0)");
        primaryStage1.setScene(scene);
        primaryStage1.setResizable(false);
        primaryStage1.initStyle(StageStyle.UNIFIED);
        primaryStage1.show();
    }

    private void initMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.setUseSystemMenuBar(true);
        Menu editMenu = new Menu("Edit");
        MenuItem prefItem = new MenuItem("Preferences");
        prefItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        prefItem.setOnAction(e -> this.showPreferencewindow());
        editMenu.getItems().add((Object)prefItem);
        prefItem.setOnAction(e -> this.showPreferencewindow());
        menuBar.getMenus().add((Object)editMenu);
        Menu helpMenu = new Menu("Help");
        MenuItem aboutItem = new MenuItem("About SonoAir");
        aboutItem.setOnAction(e -> this.getHostServices().showDocument("http://sonoair.mihosoft.eu"));
        helpMenu.getItems().add((Object)aboutItem);
        menuBar.getMenus().add((Object)helpMenu);
        if (VSysUtil.isMacOSX()) {
            ArrayList<MenuBase> menus = new ArrayList<MenuBase>();
            menus.add(GlobalMenuAdapter.adapt((Menu)editMenu));
            menus.add(GlobalMenuAdapter.adapt((Menu)helpMenu));
            Toolkit.getToolkit().getSystemMenu().setMenus(menus);
        }
    }

    private void rescanAndReRunAirSonos() {
        new Thread(() -> {
            this.stopAirSonos();
            if (this.configController.getEnableDebugProperty().get()) {
                this.outStream.println(">> DEBUG: retryCounter: " + this.retryCounter);
                if (this.configController.getNewDiscoveryMethodProperty().get()) {
                    this.outStream.println(">> DEBUG: using new discovery method");
                }
            }
            Platform.runLater(() -> this.btnTextProperty.set((Object)"Stop SonoAir"));
            this.scanDevices();
            this.zonePlayers = ZonePlayers.discover();
            this.payerGroups = this.zonePlayers.getZoneGroups((int)this.configController.getDiscoveryTimeoutProperty().get());
            if (this.configController.getNewDiscoveryMethodProperty().get()) {
                try {
                    Collections.sort(this.payerGroups, (o1, o2) -> o1.getName().compareTo(o2.getName()));
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                for (ZoneGroup player : this.payerGroups) {
                    if (!this.devices.isEmpty()) {
                        this.devices = this.devices + ",";
                    }
                    this.devices = this.devices + player.getCoordinator().getIPv4Adress();
                }
                this.updateDeviceView();
            }
            if (this.devices != null && !this.devices.isEmpty() || this.retryCounter >= 5 || this.configController.getOldDiscoveryMethodProperty().get()) {
                this.runAirSonosInNewThread(this.devices);
                this.retryCounter = 0;
            } else {
                ++this.retryCounter;
                this.rescanAndReRunAirSonos();
            }
        }).start();
    }

    private void updateDeviceView() {
        this.deviceView.getItems().clear();
        for (ZoneGroup player : this.payerGroups) {
            this.addDeviceNotification(new ZoneGroupWrapper(player));
        }
    }

    private void openControlView(Node n, ZoneGroup group) {
        String deviceName = group.getName();
        ZonePlayer zone = group.getCoordinator();
        BorderPane controlRoot = new BorderPane();
        controlRoot.getStyleClass().add((Object)"dev-control-background");
        Label label = new Label("Control " + deviceName);
        label.getStyleClass().add((Object)"device-title");
        label.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER);
        controlRoot.setTop((Node)label);
        Button doneBtn = new Button();
        doneBtn.getStyleClass().add((Object)"restart-btn");
        doneBtn.setText("Done");
        doneBtn.setAlignment(Pos.CENTER);
        doneBtn.setStyle("-fx-indent: 5 5 5 5;");
        doneBtn.setPrefHeight(20.0);
        BorderPane.setAlignment((Node)doneBtn, (Pos)Pos.CENTER);
        VBox controllerBox = new VBox();
        controllerBox.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        controlRoot.setCenter((Node)controllerBox);
        Slider volumeSlider = new Slider();
        volumeSlider.setValue((double)zone.getVolume());
        volumeSlider.setOnMouseReleased(me -> {
            if (me.getButton() == MouseButton.PRIMARY) {
                zone.setVolume((int)volumeSlider.getValue());
            }
        });
        VBox.setVgrow((Node)volumeSlider, (Priority)Priority.ALWAYS);
        Label volumeLabel = new Label("Volume");
        volumeLabel.setAlignment(Pos.CENTER);
        volumeLabel.setMaxWidth(Double.MAX_VALUE);
        VBox.setVgrow((Node)volumeLabel, (Priority)Priority.ALWAYS);
        volumeLabel.getStyleClass().add((Object)"control-label");
        VBox sliderContainer = new VBox(new Node[]{volumeLabel, volumeSlider});
        controllerBox.getChildren().add((Object)sliderContainer);
        ToggleButton ledToggleButton = new ToggleButton("");
        ledToggleButton.getStyleClass().add((Object)"led-btn");
        ledToggleButton.setMinHeight(20.0);
        ledToggleButton.setPrefHeight(20.0);
        ledToggleButton.setMaxHeight(20.0);
        ledToggleButton.setSelected(zone.isLedEnabled());
        ledToggleButton.selectedProperty().addListener((ov, oldV, newV) -> zone.setLedEnabled((boolean)newV));
        Label ledLabel = new Label("LED");
        ledLabel.getStyleClass().add((Object)"control-label");
        controllerBox.getChildren().add((Object)new StackPane(new Node[]{ledLabel}));
        controllerBox.getChildren().add((Object)new StackPane(new Node[]{ledToggleButton}));
        Stage stage = new Stage(StageStyle.TRANSPARENT);
        controlRoot.setBottom((Node)doneBtn);
        doneBtn.setOnAction(ae -> stage.close());
        Scene scene = new Scene((Parent)controlRoot, 400.0, 200.0);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.getStylesheets().add((Object)"/eu/mihosoft/sonoair/maininterface.css");
        stage.initOwner((Window)this.primaryStage);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.setTitle("Control Device: " + deviceName);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.setX(this.primaryStage.getX() + this.primaryStage.getWidth() / 2.0 - 400.0);
        stage.setY(this.primaryStage.getY() + this.primaryStage.getHeight() / 2.0 - 200.0);
        stage.setOpacity(0.98);
        stage.show();
        stage.setX(this.primaryStage.getX() + this.primaryStage.getWidth() / 2.0 - stage.getWidth() / 2.0);
        stage.setY(this.primaryStage.getY() + this.primaryStage.getHeight() / 2.0 - stage.getHeight() / 2.0);
    }

    private void showPreferencewindow() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("Preferences.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(SonoAir.class.getName()).log(Level.SEVERE, null, ex);
        }
        PreferencesController controller = (PreferencesController)fxmlLoader.getController();
        controller.setConfigController(this.configController);
        this.configController.loadConfig();
        Scene scene = new Scene((Parent)fxmlLoader.getRoot(), 600.0, 400.0);
        Stage configStage = new Stage();
        configStage.setScene(scene);
        configStage.setTitle("SonoAir: Preferences");
        configStage.setOnCloseRequest(we -> {
            if (this.configController.getEnableDebugProperty().get()) {
                System.setErr(this.outStream);
            } else {
                System.setErr(RedirectableStream.ORIGINAL_SERR);
            }
            this.rescanAndReRunAirSonos();
        });
        configStage.show();
    }

    private void showDonationPage() {
        Stage donationStage = new Stage(StageStyle.UNIFIED);
        WebView view = new WebView();
        view.getEngine().load("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=WQC8SVJ2P7PNG");
        Scene scene = new Scene((Parent)view, 800.0, 600.0);
        donationStage.setScene(scene);
        donationStage.setTitle("Donate");
        donationStage.initOwner((Window)this.primaryStage);
        donationStage.initModality(Modality.WINDOW_MODAL);
        donationStage.show();
    }

    private void runAirSonosInNewThread(String devices) {
        Thread t = new Thread(() -> this.runAirSonos(devices));
        t.start();
    }

    public void stop() throws Exception {
        this.stopAirSonos();
        System.exit(0);
    }

    private boolean isAirsonosRunning() {
        return this.process != null;
    }

    private void runAirSonos(String devices) {
        this.dividerProperty.set(1.0);
        if (!this.configController.getEnableDebugProperty().get()) {
            this.outputArea.setText("");
        }
        this.outStream.println("SonoAir v1.0 (BETA 4.0)");
        this.outStream.println("Copyright (c) 2015 Michael Hoffer <info@michaelhoffer.de>");
        this.outStream.println("--------------------------------------------------------------");
        this.outStream.println("-> using node-v0.10.28-darwin-x64");
        this.outStream.println("-> using airsonos by Stephen Wan");
        this.outStream.println("   see https://github.com/stephen/airsonos/blob/master/LICENSE");
        this.outStream.print("-> starting airsonos module...");
        if (this.isAirsonosRunning()) {
            this.stopAirSonos();
        }
        ArrayList<String> execArgs = new ArrayList<String>();
        execArgs.add(this.baseDir.getPath() + "/resources/osx/node-v0.10.28-darwin-x64/bin/node");
        execArgs.add(this.baseDir.getPath() + "/resources/osx/node-v0.10.28-darwin-x64/bin/airsonos");
        if (devices != null && !devices.trim().isEmpty()) {
            execArgs.add("--device-list");
            execArgs.add(devices);
        }
        ProcessBuilder builder = new ProcessBuilder(execArgs.toArray(new String[execArgs.size()]));
        builder.redirectErrorStream(true);
        try {
            String line;
            String execLine;
            ProcessBuilder execBuilder = new ProcessBuilder("chmod", "a+x", this.baseDir.getPath() + "/resources/osx/node-v0.10.28-darwin-x64/bin/node");
            builder.redirectErrorStream(true);
            Process makeExecutable = execBuilder.start();
            BufferedReader executableReader = new BufferedReader(new InputStreamReader(makeExecutable.getInputStream()));
            while ((execLine = executableReader.readLine()) != null) {
            }
            this.process = builder.start();
            this.outStream.println(" [done]\n--------------------------------------------------------------");
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Setting up SonoAir for")) {
                    ZoneGroup zoneGrp;
                    String devName;
                    block16: {
                        this.outStream.println(line);
                        if (!this.configController.getOldDiscoveryMethodProperty().get() && devices != null && !devices.isEmpty()) continue;
                        if (this.configController.getEnableDebugProperty().get()) {
                            this.outStream.println(">> DEBUG: using old discovery method");
                            if ((devices == null || devices.isEmpty()) && this.configController.getNewDiscoveryMethodProperty().get()) {
                                this.outStream.println(">> DEBUG: fallback since new discovery was not successful.");
                            }
                        }
                        devName = line.replace("Setting up SonoAir for ", "").replaceAll("\\{.*\\}", "").trim();
                        zoneGrp = null;
                        try {
                            zoneGrp = this.zonePlayers.getDiscoveredZoneGroups().stream().filter(zg -> zg.getName().contains(devName)).findFirst().orElse(null);
                        }
                        catch (Exception ex) {
                            if (!this.configController.getEnableDebugProperty().get()) break block16;
                            ex.printStackTrace(this.outStream);
                        }
                    }
                    if (this.configController.getEnableDebugProperty().get()) {
                        this.outStream.println(">> DEBUG: zg: " + zoneGrp + ", for name " + devName);
                    }
                    if (zoneGrp == null) {
                        this.addDeviceNotification(new ZoneGroupWrapper(devName));
                        continue;
                    }
                    this.addDeviceNotification(new ZoneGroupWrapper(zoneGrp));
                    continue;
                }
                if (line.startsWith("Searching for Sonos devices on network")) {
                    this.outStream.println(line);
                    this.scanDevices();
                    continue;
                }
                if (line.contains("Warning! Codec not supported") || line.contains("AirSonos currently does not support codecs") || line.contains("Progress on this issue: https://github.com/stephen/nodetunes/issues/1")) {
                    if (this.outputArea.getText().contains("SonoAir does not support the requested codec.")) continue;
                    this.outStream.println("ERROR:    SonoAir does not support the requested codec.");
                    this.outStream.println("SOLUTION: select SonoAir audio source from menu bar (ALT + Primary Mousebutton)");
                    this.outStream.println("          For more information visit:");
                    this.outStream.println("          http://sonoair.mihosoft.eu/codec-not-supported.html");
                    this.dividerProperty.set(0.0);
                    continue;
                }
                this.outStream.println(line);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SonoAir.class.getName()).log(Level.SEVERE, null, ex);
            this.outStream.println(" [failed]");
            this.dividerProperty.set(0.0);
            this.stopAirSonos();
        }
    }

    private void addDeviceNotification(ZoneGroupWrapper group) {
        System.out.println("Adding device " + group.toString());
        Platform.runLater(() -> {
            this.deviceView.getItems().add((Object)group);
            this.primaryStage.setTitle("SonoAir v1.0 (BETA 4.0)");
        });
    }

    private void scanDevices() {
        Platform.runLater(() -> this.primaryStage.setTitle("SonoAir v1.0 (BETA 4.0) (searching devices...)"));
    }

    public static void main(String[] args) {
        SonoAir.launch((String[])args);
    }

    private void stopAirSonos() {
        this.devices = "";
        Platform.runLater(() -> {
            this.windowTitleProperty.set((Object)"SonoAir v1.0 (BETA 4.0)");
            this.deviceView.getItems().clear();
            this.btnTextProperty.set((Object)"Start SonoAir");
        });
        if (this.process != null) {
            try {
                this.process.destroy();
            }
            finally {
                this.process = null;
                this.outStream.println("--------------------------------------------------------------");
                this.outStream.println("-> airsonos module stopped.");
            }
        }
    }
}

