/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.Base64;
import eu.mihosoft.vrl.base.ConfigurationFile;
import eu.mihosoft.vrl.base.ConfigurationFileImpl;
import eu.mihosoft.vrl.base.VParamUtil;
import eu.mihosoft.vrl.base.VRL;
import eu.mihosoft.vrl.base.VSysUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class IOUtil {
    private static boolean IO_DEBUG = false;
    private static boolean DISABLE_SHUTDOWN_HOOK = false;
    private static final Collection<String> filesToDeleteOnExit = new ArrayList<String>();

    public static void disableShutdownHook(boolean b) {
        DISABLE_SHUTDOWN_HOOK = b;
    }

    public static boolean isShutdownHookDisabled() {
        return DISABLE_SHUTDOWN_HOOK;
    }

    public static ConfigurationFile newConfigurationFile(File f) {
        return new ConfigurationFileImpl(f);
    }

    public static boolean isDebugginEnabled() {
        return IO_DEBUG;
    }

    public static void enableDebugging(boolean state) {
        IO_DEBUG = state;
    }

    private IOUtil() {
        throw new AssertionError();
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static byte[] fileToByteArray(File file) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] result = new byte[(int)file.length()];
        fileInputStream.read(result);
        fileInputStream.close();
        return result;
    }

    public static String fileToBase64(File file) throws FileNotFoundException, IOException {
        return Base64.encodeBytes(IOUtil.fileToByteArray(file));
    }

    public static byte[] base64ToByteArray(String data) {
        return Base64.decode(data);
    }

    @Deprecated
    public static String generateSHASum(byte[] data) {
        return IOUtil.generateSHA1Sum(data);
    }

    public static String generateSHA1Sum(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            return IOUtil.convertToHex(md.digest(data));
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String generateSHA1Sum(File f) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            return IOUtil.convertToHex(md.digest(IOUtil.fileToByteArray(f)));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    public static String generateMD5Sum(File f) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            return IOUtil.convertToHex(md.digest(IOUtil.fileToByteArray(f)));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    public static long generateCRC32Sum(byte[] bytes) {
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    public static long generateCRC32Sum(File f) {
        try {
            return IOUtil.generateCRC32Sum(IOUtil.fileToByteArray(f));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0L;
    }

    public static String generateSHA256um(File f) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            return IOUtil.convertToHex(md.digest(IOUtil.fileToByteArray(f)));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    public static String generateSHA256Sum(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            return IOUtil.convertToHex(md.digest(data));
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String generateMD5Sum(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            return IOUtil.convertToHex(md.digest(data));
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static boolean verifyFileMD5(File f, String checksum) {
        try {
            byte[] fileData = IOUtil.fileToByteArray(f);
            String checksumOfFile = IOUtil.generateMD5Sum(fileData);
            return checksum.equals(checksumOfFile);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public static boolean verifyFileSHA1(File f, String checksum) {
        if (IOUtil.isDebugginEnabled()) {
            System.out.println(">> IOUtil.verifyFileSHA1: " + f);
        }
        try {
            byte[] fileData = IOUtil.fileToByteArray(f);
            String checksumOfFile = IOUtil.generateSHA1Sum(fileData);
            if (IOUtil.isDebugginEnabled()) {
                System.out.println(" --> sum1: " + checksum);
                System.out.println(" --> sum2: " + checksumOfFile);
                System.out.println(" -- result: " + checksum.equals(checksumOfFile));
            }
            return checksum.equals(checksumOfFile);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public static File getRootParent(File f) {
        File parent = f.getAbsoluteFile();
        while (parent != null) {
            File pF = parent.getAbsoluteFile().getParentFile();
            if (pF == null) {
                return parent;
            }
            parent = pF;
        }
        return parent;
    }

    public static long getFreeSpaceOnPartition(File f) {
        return f.getUsableSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSize(File f) {
        InputStream stream = null;
        try {
            URL url = f.toURI().toURL();
            stream = url.openStream();
            long l = stream.available();
            return l;
        }
        catch (IOException ex) {
            Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return -1L;
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (IO_DEBUG) {
            System.out.println(">> Copy:");
            System.out.println(" --> from: " + sourceLocation);
            System.out.println(" --> to: " + targetLocation);
        }
        VParamUtil.throwIfNull(sourceLocation, targetLocation);
        if (!sourceLocation.exists()) {
            throw new FileNotFoundException(sourceLocation.getPath());
        }
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdirs();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                IOUtil.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            IOUtil.copyFile(sourceLocation, targetLocation);
        }
    }

    public static ArrayList<File> listFiles(File dir, String pattern) {
        return IOUtil._listFiles(dir, pattern, new ArrayList<File>());
    }

    private static ArrayList<File> _listFiles(File fileOrDir, String pattern, ArrayList<File> files) {
        VParamUtil.throwIfNull(fileOrDir, pattern);
        if (!fileOrDir.isDirectory()) {
            files.add(fileOrDir);
        } else {
            VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FOLDER, null, fileOrDir);
            if (fileOrDir.isDirectory()) {
                String[] children = fileOrDir.list();
                for (int i = 0; i < children.length; ++i) {
                    IOUtil._listFiles(new File(fileOrDir, children[i]), pattern, files);
                }
            } else if (fileOrDir.getName().matches(pattern)) {
                files.add(fileOrDir);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceLocation, File targetLocation) throws FileNotFoundException, IOException {
        VParamUtil.throwIfNull(sourceLocation, targetLocation);
        VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FILE, null, sourceLocation);
        try (FileChannel sourceChannel = new FileInputStream(sourceLocation).getChannel();
             FileChannel targetChannel = new FileOutputStream(targetLocation).getChannel();){
            targetChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
    }

    public static File byteArrayToTmpFile(byte[] data, String extension) throws IOException {
        File result = File.createTempFile("vrl", "." + extension);
        result.deleteOnExit();
        FileOutputStream out = new FileOutputStream(result);
        out.write(data);
        out.flush();
        out.close();
        return result;
    }

    public static File byteArrayToTmpFile(byte[] data) throws IOException {
        return IOUtil.byteArrayToTmpFile(data, "tmp");
    }

    public static File stringToTmpFile(String data) throws IOException {
        return IOUtil.byteArrayToTmpFile(data.getBytes());
    }

    public static File stringToTmpFile(String data, String extension) throws IOException {
        return IOUtil.byteArrayToTmpFile(data.getBytes(), extension);
    }

    public static File base64ToTmpFile(String data, String extension) throws IOException {
        File result = File.createTempFile("vrl", "." + extension);
        result.deleteOnExit();
        FileOutputStream out = new FileOutputStream(result);
        out.write(Base64.decode(data, 2));
        out.flush();
        out.close();
        return result;
    }

    public static File base64ToFile(String data, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        out.write(Base64.decode(data, 2));
        out.flush();
        out.close();
        return f;
    }

    public static File base64ToTmpFile(String data) throws IOException {
        return IOUtil.base64ToTmpFile(data, "tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> readFileToStringList(File file) {
        ArrayList<String> contents = new ArrayList<String>();
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringListToFile(File file, List<String> lines) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        try (BufferedWriter output = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                output.write(line + "\n");
            }
        }
    }

    public static boolean deleteDirectory(File dir) {
        return IOUtil.deleteDirectory(dir, null);
    }

    public static boolean deleteDirectory(File dir, Collection<File> excludes) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOUtil.deleteDirectory(new File(dir, children[i]), excludes);
                if (success) continue;
                return false;
            }
        }
        boolean exclude = false;
        if (excludes != null) {
            for (File f : excludes) {
                if (!dir.getAbsolutePath().startsWith(f.getAbsolutePath())) continue;
                exclude = true;
                break;
            }
        }
        if (excludes == null || !exclude) {
            boolean result = dir.delete();
            if (IOUtil.isDebugginEnabled()) {
                System.out.println("DELETE: " + result + ", " + dir);
            }
            return result;
        }
        return true;
    }

    public static boolean deleteContainedFilesAndDirs(File dir) {
        return IOUtil.deleteContainedFilesAndDirs(dir, null);
    }

    public static boolean deleteContainedFilesAndDirs(File dir, Collection<File> excludes) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOUtil.deleteDirectory(new File(dir, children[i]), excludes);
                if (success) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean move(File src, File dest) {
        if (VSysUtil.isWindows() && dest.exists()) {
            if (dest.isDirectory()) {
                return false;
            }
            IOUtil.deleteDirectory(dest);
        }
        return src.renameTo(dest);
    }

    public static File createTempDir(File dir) throws IOException {
        File newTempDir;
        File sysTempDir = dir;
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount > 9) {
                throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
            }
            String dirName = UUID.randomUUID().toString();
            newTempDir = new File(sysTempDir, dirName);
            newTempDir.deleteOnExit();
        } while (newTempDir.exists());
        if (newTempDir.mkdirs()) {
            IOUtil.deleteTmpFilesOnExit(newTempDir);
            return newTempDir;
        }
        throw new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath());
    }

    public static File createTempDir() throws IOException {
        return IOUtil.createTempDir(VRL.getPropertyFolderManager().getTmpFolder());
    }

    public static void deleteTmpFilesOnExit(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            fileOrDir.deleteOnExit();
            for (File innerFile : fileOrDir.listFiles()) {
                IOUtil.deleteTmpFilesOnExit(innerFile);
            }
        } else if (fileOrDir.isFile()) {
            fileOrDir.deleteOnExit();
        }
    }

    public static void deleteTmpFilesOnExitIgnoreFileLocks(File fileOrDir) {
        if (VSysUtil.isWindows()) {
            filesToDeleteOnExit.add(fileOrDir.getAbsolutePath());
            return;
        }
        if (fileOrDir.isDirectory()) {
            fileOrDir.deleteOnExit();
            for (File innerFile : fileOrDir.listFiles()) {
                IOUtil.deleteTmpFilesOnExit(innerFile);
            }
        } else if (fileOrDir.isFile()) {
            fileOrDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveStreamToFile(InputStream in, File f) throws FileNotFoundException, IOException {
        VParamUtil.throwIfNull(in, f);
        FileOutputStream out = new FileOutputStream(f);
        try {
            int read2332 = 0;
            byte[] bytes = new byte[1024];
            while ((read2332 = in.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read2332);
            }
        }
        catch (IOException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
                finally {
                    try {
                        out.flush();
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            in.close();
            return;
        }
        catch (IOException read2332) {
            return;
        }
        finally {
            try {
                out.flush();
                ((OutputStream)out).close();
            }
            catch (IOException read2332) {}
        }
    }

    public static ArrayList<File> listFiles(File sourceLocation, String[] endings) {
        ArrayList<File> result = new ArrayList<File>();
        IOUtil._getFilesRecursive(sourceLocation, result, endings);
        return result;
    }

    private static void _getFilesRecursive(File location, Collection<File> files, String[] endings) {
        if (location.isDirectory()) {
            String[] children = location.list();
            for (int i = 0; i < children.length; ++i) {
                IOUtil._getFilesRecursive(new File(location, children[i]), files, endings);
            }
        } else {
            for (String ending : endings) {
                if (!location.getAbsolutePath().endsWith(ending)) continue;
                files.add(location);
                break;
            }
        }
    }

    private static Set<File> _getFilteredContent(File srcFolder, String ... endings) {
        HashSet<File> result = new HashSet<File>();
        if (IOUtil.isDebugginEnabled()) {
            for (String e : endings) {
                System.out.println("ENDING: " + (String)e);
            }
        }
        for (File f : srcFolder.listFiles()) {
            boolean fMatches = false;
            for (String e : endings) {
                if (!f.getAbsolutePath().endsWith(e) && !f.getPath().contains(e)) continue;
                fMatches = true;
                break;
            }
            if (IOUtil.isDebugginEnabled()) {
                System.out.println("Matches: [" + fMatches + "] = " + f);
            }
            if (fMatches) {
                result.add(f);
                if (!f.isDirectory()) continue;
                result.addAll(IOUtil._getFilteredContent(f, ""));
                continue;
            }
            if (!f.isDirectory()) continue;
            result.addAll(IOUtil._getFilteredContent(f, endings));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipContentOfFolder(File srcFolder, File destZipFile, String ... endings) throws IOException {
        VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FOLDER, null, srcFolder);
        URI base = srcFolder.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(srcFolder);
        FileOutputStream out = new FileOutputStream(destZipFile);
        OutputStream res = out;
        Set<File> matchedFiles = IOUtil._getFilteredContent(srcFolder, endings);
        if (IOUtil.isDebugginEnabled()) {
            System.out.println("Zipping Files: ");
            for (File f : matchedFiles) {
                System.out.println(" --> f: " + f);
            }
        }
        try {
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            while (!queue.isEmpty()) {
                srcFolder = (File)queue.pop();
                for (File kid : srcFolder.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    if (!matchedFiles.contains(kid)) continue;
                    zout.putNextEntry(new ZipEntry(name));
                    IOUtil._copy(kid, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
        finally {
            res.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipContentOfFolder(File srcFolder, File destZipFile) throws IOException {
        VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FOLDER, null, srcFolder);
        File[] childrenOfSrc = srcFolder.listFiles();
        if (childrenOfSrc.length == 0) {
            throw new IllegalArgumentException("Source folder must contain at least one entry!");
        }
        URI base = srcFolder.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(srcFolder);
        FileOutputStream out = new FileOutputStream(destZipFile);
        try (OutputStream res = out;){
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            while (!queue.isEmpty()) {
                srcFolder = (File)queue.pop();
                for (File kid : srcFolder.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        zout.closeEntry();
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    IOUtil._copy(kid, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolder(File srcFolder, File destZipFile) throws IOException {
        VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FOLDER, null, srcFolder);
        URI base = srcFolder.getParentFile().toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(srcFolder);
        FileOutputStream out = new FileOutputStream(destZipFile);
        try (OutputStream res = out;){
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            String baseName = srcFolder.getName();
            if (!baseName.endsWith("/")) {
                baseName = baseName + "/";
            }
            zout.putNextEntry(new ZipEntry(baseName));
            while (!queue.isEmpty()) {
                srcFolder = (File)queue.pop();
                for (File kid : srcFolder.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    IOUtil._copy(kid, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File archive, File destDir) throws IOException {
        VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FILE, null, archive);
        ZipFile zfile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(destDir, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            try (InputStream in = zfile.getInputStream(entry);){
                IOUtil._copy(in, entry.getSize(), file);
            }
        }
        zfile.close();
    }

    private static void _copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    private static void _copy(File file, OutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            IOUtil._copy(in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _copy(InputStream in, long size, File file) throws IOException {
        FileChannel targetChannel = new FileOutputStream(file).getChannel();
        try (ReadableByteChannel sourceChannel = Channels.newChannel(in);){
            try {
                targetChannel.transferFrom(sourceChannel, 0L, size);
            }
            finally {
                targetChannel.close();
            }
        }
    }

    static {
        if (VSysUtil.isWindows()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    if (DISABLE_SHUTDOWN_HOOK) {
                        return;
                    }
                    String deleteCmds = "";
                    for (String f : filesToDeleteOnExit) {
                        deleteCmds = deleteCmds + " rd /s/q \"\"\"\"" + f + "\"\"&";
                    }
                    String cmd = "cmd.exe /c \" start /w/min cmd.exe /c \"\"ping -n 5 127.0.0.1 > NUL &" + deleteCmds + "\"\" \"";
                    System.err.println("executing:\n" + cmd);
                    try {
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(IOUtil.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }));
        }
    }
}

