/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.LockedTask;
import eu.mihosoft.vrl.base.SynchronizedFileTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SynchronizedFileAccess {
    public static synchronized void access(SynchronizedFileTask fTask, File f, int maxRetries, long retryDelay) throws FileNotFoundException, IOException {
        SynchronizedFileAccess.access(fTask, f, maxRetries, retryDelay, true);
    }

    private static synchronized void access(SynchronizedFileTask fTask, File f, int maxRetries, long retryDelay, boolean unlock) throws FileNotFoundException, IOException {
        if (f.exists()) {
            FileLock lock;
            FileChannel channel = new RandomAccessFile(f, "rw").getChannel();
            for (int counter = 0; (lock = channel.tryLock()) == null && counter < maxRetries; ++counter) {
                System.out.println(">> SFA: Resource unavailable. Trying again in " + (float)retryDelay / 1000.0f + " sec.");
                try {
                    Thread.sleep(retryDelay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (lock != null) {
                fTask.performTask(f);
            }
            if (unlock) {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                    channel.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            fTask.performTask(f);
        }
    }

    public static synchronized boolean lockFile(File f) {
        LockedTask task = new LockedTask();
        try {
            SynchronizedFileAccess.access(task, f, false);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SynchronizedFileAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SynchronizedFileAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
        return task.locked;
    }

    public static synchronized boolean isLocked(File f) {
        LockedTask task = new LockedTask();
        try {
            SynchronizedFileAccess.access(task, f);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SynchronizedFileAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SynchronizedFileAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
        return task.locked;
    }

    public static synchronized void access(SynchronizedFileTask fTask, File f) throws FileNotFoundException, IOException {
        SynchronizedFileAccess.access(fTask, f, 10, 300L);
    }

    private static synchronized void access(SynchronizedFileTask fTask, File f, boolean unlock) throws FileNotFoundException, IOException {
        SynchronizedFileAccess.access(fTask, f, 10, 300L, unlock);
    }
}

