/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.security.AccessController;
import javafx.application.Platform;
import javafx.scene.input.TransferMode;

class GlassSceneDnDEventHandler {
    private final GlassScene scene;

    public GlassSceneDnDEventHandler(GlassScene glassScene) {
        this.scene = glassScene;
    }

    public TransferMode handleDragEnter(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance, false);
                return this.scene.dropTargetListener.dragEnter(n, n2, n3, n4, transferMode, quantumClipboard);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public void handleDragLeave(ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                this.scene.dropTargetListener.dragExit(0.0, 0.0, 0.0, 0.0);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public TransferMode handleDragDrop(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                return this.scene.dropTargetListener.drop(n, n2, n3, n4, transferMode);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public TransferMode handleDragOver(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(() -> {
            if (this.scene.dropTargetListener != null) {
                return this.scene.dropTargetListener.dragOver(n, n2, n3, n4, transferMode);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public void handleDragStart(int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(() -> {
            if (this.scene.dragGestureListener != null) {
                QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance, true);
                this.scene.dragGestureListener.dragGestureRecognized(n2, n3, n4, n5, n, quantumClipboard);
            }
            return null;
        }, this.scene.getAccessControlContext());
    }

    public void handleDragEnd(TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(() -> {
            try {
                if (this.scene.dragSourceListener != null) {
                    this.scene.dragSourceListener.dragDropEnd(0.0, 0.0, 0.0, 0.0, transferMode);
                }
            }
            finally {
                QuantumClipboard.releaseCurrentDragboard();
            }
            return null;
        }, this.scene.getAccessControlContext());
    }
}

