/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.prism.PixelSource;

public class PresentableState {
    protected Window window;
    protected View view;
    protected int windowX;
    protected int windowY;
    protected float windowAlpha;
    protected long nativeWindowHandle;
    protected long nativeView;
    protected int viewWidth;
    protected int viewHeight;
    protected int screenHeight;
    protected int screenWidth;
    protected boolean isWindowVisible;
    protected boolean isWindowMinimized;
    protected float screenScale;
    protected static boolean hasWindowManager = Application.GetApplication().hasWindowManager();
    protected boolean isClosed;
    protected final int pixelFormat = Pixels.getNativeFormat();

    public int getWindowX() {
        return this.windowX;
    }

    public int getWindowY() {
        return this.windowY;
    }

    public int getWidth() {
        return this.viewWidth;
    }

    public int getHeight() {
        return this.viewHeight;
    }

    public float getScale() {
        return this.screenScale;
    }

    public float getAlpha() {
        return this.windowAlpha;
    }

    public long getNativeWindow() {
        return this.nativeWindowHandle;
    }

    public long getNativeView() {
        return this.nativeView;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public boolean isViewClosed() {
        return this.isClosed;
    }

    public boolean isWindowMinimized() {
        return this.isWindowMinimized;
    }

    public boolean isWindowVisible() {
        return this.isWindowVisible;
    }

    public boolean hasWindowManager() {
        return hasWindowManager;
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean isMSAA() {
        return false;
    }

    public View getView() {
        return this.view;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void lock() {
        if (this.view != null) {
            this.view.lock();
        }
    }

    public void unlock() {
        if (this.view != null) {
            this.view.unlock();
        }
    }

    public void uploadPixels(PixelSource pixelSource) {
        Pixels pixels = pixelSource.getLatestPixels();
        if (pixels != null) {
            try {
                this.view.uploadPixels(pixels);
            }
            finally {
                pixelSource.doneWithPixels(pixels);
            }
        }
    }

    public void update() {
        if (this.view != null) {
            this.viewWidth = this.view.getWidth();
            this.viewHeight = this.view.getHeight();
            this.window = this.view.getWindow();
        } else {
            this.viewHeight = -1;
            this.viewWidth = -1;
            this.window = null;
        }
        if (this.window != null) {
            this.windowX = this.window.getX();
            this.windowY = this.window.getY();
            this.windowAlpha = this.window.getAlpha();
            this.nativeView = this.view.getNativeView();
            this.nativeWindowHandle = this.window.getNativeWindow();
            this.isClosed = this.view.isClosed();
            this.isWindowVisible = this.window.isVisible();
            this.isWindowMinimized = this.window.isMinimized();
            Screen screen = this.window.getScreen();
            if (screen != null) {
                this.screenHeight = screen.getHeight();
                this.screenWidth = screen.getWidth();
                this.screenScale = screen.getScale();
            } else {
                this.screenScale = 1.0f;
            }
        } else {
            this.nativeView = -1L;
            this.nativeWindowHandle = -1L;
            this.isClosed = true;
        }
    }
}

