/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class JarContainer
implements Comparable<JarContainer> {
    private static Map<String, String> mavenGroupIdDatabase;
    public static final String MODE_BASENAME = "BASENAME";
    public static final String MODE_FULLNAME = "FULLNAME";
    private static String mode;
    private Collection<String> origins = new TreeSet<String>();
    private String description = "";
    private boolean actif = true;
    private Collection<String> destinations = new TreeSet<String>();
    private Collection<String> modules = new TreeSet<String>();
    private String key = "";
    private String groupId = "";
    private String artifactId = "";
    private String version = "";
    private String jarName = "";
    private String startConstantsKey = "";
    private String startConstantsRegExp = "";
    private int cksum = 0;
    private String path = "";

    private static JarContainer findJar(Collection<JarContainer> jars, JarContainer jarToMatch) {
        for (JarContainer jar : jars) {
            if (!jar.getArtifactId().equalsIgnoreCase(jarToMatch.getArtifactId()) || !jar.getVersion().equalsIgnoreCase(jarToMatch.getVersion()) || jar == jarToMatch) continue;
            return jar;
        }
        return null;
    }

    public static Collection<JarContainer> fusion(Collection<JarContainer> jars) {
        ArrayList<JarContainer> merged = new ArrayList<JarContainer>();
        ArrayList<JarContainer> processed = new ArrayList<JarContainer>();
        for (JarContainer jar : jars) {
            JarContainer similijar;
            if (processed.contains(jar) || jar == (similijar = JarContainer.findJar(merged, jar))) continue;
            if (similijar == null) {
                merged.add(jar);
            } else {
                similijar.fusion(jar);
            }
            processed.add(jar);
        }
        return merged;
    }

    public static Map<String, String> getMavenGroupIdDatabase() {
        if (mavenGroupIdDatabase == null) {
            mavenGroupIdDatabase = new HashMap<String, String>();
            mavenGroupIdDatabase.put("antlr", "antlr");
            mavenGroupIdDatabase.put("aopalliance", "aopalliance");
            mavenGroupIdDatabase.put("asm", "asm");
            mavenGroupIdDatabase.put("asm-attrs", "asm");
            mavenGroupIdDatabase.put("backport-util-concurrent", "backport-util-concurrent");
            mavenGroupIdDatabase.put("batik-awt-util", "batik");
            mavenGroupIdDatabase.put("batik-dom", "batik");
            mavenGroupIdDatabase.put("batik-svggen", "batik");
            mavenGroupIdDatabase.put("bsh", "bsh");
            mavenGroupIdDatabase.put("castor", "castor");
            mavenGroupIdDatabase.put("cglib", "cglib");
            mavenGroupIdDatabase.put("maxq", "com.bitmechanic.maxq");
            mavenGroupIdDatabase.put("h2", "com.h2database");
            mavenGroupIdDatabase.put("jmep", "com.iabcinc.jmep");
            mavenGroupIdDatabase.put("icu4j", "com.ibm.icu");
            mavenGroupIdDatabase.put("cdn", "com.inetpsa.cdn00");
            mavenGroupIdDatabase.put("clppkannuldap", "com.inetpsa.clp");
            mavenGroupIdDatabase.put("ddl-core", "com.inetpsa.ddl00");
            mavenGroupIdDatabase.put("ddl-java", "com.inetpsa.ddl00");
            mavenGroupIdDatabase.put("ecw-core", "com.inetpsa.ecw00");
            mavenGroupIdDatabase.put("ecw-struts", "com.inetpsa.ecw00");
            mavenGroupIdDatabase.put("elf-java", "com.inetpsa.elf00");
            mavenGroupIdDatabase.put("fwk-commons", "com.inetpsa.fwk");
            mavenGroupIdDatabase.put("fwk-core", "com.inetpsa.fwk");
            mavenGroupIdDatabase.put("fwk-i18n", "com.inetpsa.fwk");
            mavenGroupIdDatabase.put("fwk-i18n-db", "com.inetpsa.fwk");
            mavenGroupIdDatabase.put("fwk-i18n-hibernate", "com.inetpsa.fwk");
            mavenGroupIdDatabase.put("fwk-noyau", "com.inetpsa.fwk");
            mavenGroupIdDatabase.put("fwk-struts", "com.inetpsa.fwk");
            mavenGroupIdDatabase.put("gan", "com.inetpsa.gan00");
            mavenGroupIdDatabase.put("ltp-java", "com.inetpsa.ltp00");
            mavenGroupIdDatabase.put("ltp-start", "com.inetpsa.ltp00");
            mavenGroupIdDatabase.put("ltp-strutsv1", "com.inetpsa.ltp00");
            mavenGroupIdDatabase.put("mqp", "com.inetpsa.mqp00");
            mavenGroupIdDatabase.put("tbf-common", "com.inetpsa.tbf00");
            mavenGroupIdDatabase.put("tbf-telnet", "com.inetpsa.tbf00");
            mavenGroupIdDatabase.put("tbf-txcom", "com.inetpsa.tbf00");
            mavenGroupIdDatabase.put("itext", "com.lowagie");
            mavenGroupIdDatabase.put("commons-beanutils", "commons-beanutils");
            mavenGroupIdDatabase.put("commons-betwixt", "commons-betwixt");
            mavenGroupIdDatabase.put("commons-cache", " commons-cache");
            mavenGroupIdDatabase.put("commons-cli", "commons-cli");
            mavenGroupIdDatabase.put("commons-codec", "commons-codec");
            mavenGroupIdDatabase.put("commons-collections", "commons-collections");
            mavenGroupIdDatabase.put("commons-configuration", "commons-configuration");
            mavenGroupIdDatabase.put("commons-dbcp", "commons-dbcp");
            mavenGroupIdDatabase.put("commons-digester", "commons-digester");
            mavenGroupIdDatabase.put("commons-email", "commons-email");
            mavenGroupIdDatabase.put("commons-fileupload", "commons-fileupload");
            mavenGroupIdDatabase.put("commons-httpclient", "commons-httpclient");
            mavenGroupIdDatabase.put("commons-io", "commons-io");
            mavenGroupIdDatabase.put("commons-jxpath", "commons-jxpath");
            mavenGroupIdDatabase.put("commons-lang", "commons-lang");
            mavenGroupIdDatabase.put("commons-logging", "commons-logging");
            mavenGroupIdDatabase.put("commons-logging-api", "commons-logging");
            mavenGroupIdDatabase.put("commons-net", "commons-net");
            mavenGroupIdDatabase.put("commons-pool", "commons-pool");
            mavenGroupIdDatabase.put("commons-validator", "commons-validator");
            mavenGroupIdDatabase.put("dom4j", "dom4j");
            mavenGroupIdDatabase.put("gnu-regexp", "gnu-regexp");
            mavenGroupIdDatabase.put("hsqldb", "hsqldb");
            mavenGroupIdDatabase.put("activation", "javax.activation");
            mavenGroupIdDatabase.put("mail", "javax.mail");
            mavenGroupIdDatabase.put("jmxremote", "javax.management");
            mavenGroupIdDatabase.put("jmxremote_optional", "javax.management");
            mavenGroupIdDatabase.put("jmxri", "javax.management");
            mavenGroupIdDatabase.put("jta", "javax.transaction");
            mavenGroupIdDatabase.put("jaxen", "jaxen");
            mavenGroupIdDatabase.put("jdom", "jdom");
            mavenGroupIdDatabase.put("jcommon", "jfree");
            mavenGroupIdDatabase.put("jfreechart", "jfree");
            mavenGroupIdDatabase.put("azzurri_clay_core", "jp.azzurri");
            mavenGroupIdDatabase.put("junit", "junit");
            mavenGroupIdDatabase.put("jython", "jython");
            mavenGroupIdDatabase.put("log4j", "log4j");
            mavenGroupIdDatabase.put("menu", "menu");
            mavenGroupIdDatabase.put("jericho-html", "net.htmlparser");
            mavenGroupIdDatabase.put("ehcache", "net.sf.ehcache");
            mavenGroupIdDatabase.put("jsr107cache", "net.sf.jsr107cache");
            mavenGroupIdDatabase.put("opencsv", "net.sf.opencsv");
            mavenGroupIdDatabase.put("db-ojb", "ojb");
            mavenGroupIdDatabase.put("quartz", "opensymphony");
            mavenGroupIdDatabase.put("ojdbc14", "oracle.jdbc-driver");
            mavenGroupIdDatabase.put("ant", "org.apache.ant");
            mavenGroupIdDatabase.put("ant-launcher", "org.apache.ant");
            mavenGroupIdDatabase.put("axis2", "org.apache.axis2");
            mavenGroupIdDatabase.put("aspectjweaver", "org.aspectj");
            mavenGroupIdDatabase.put("wstx-asl", "org.codehaus.woodstox");
            mavenGroupIdDatabase.put("hibernate", "org.hibernate");
            mavenGroupIdDatabase.put("jtidy", "org.hibernate");
            mavenGroupIdDatabase.put("azzurri_clay_core", "jp.azzurri");
            mavenGroupIdDatabase.put("spring-web", "org.springframework");
            mavenGroupIdDatabase.put("spring-security-taglibs", "org.springframework.security");
            mavenGroupIdDatabase.put("spring-security-acl", "org.springframework.security");
            mavenGroupIdDatabase.put("", "");
            mavenGroupIdDatabase.put("", "");
            mavenGroupIdDatabase.put("", "");
            mavenGroupIdDatabase.put("slf4j-api", "org.slf4j");
            mavenGroupIdDatabase.put("slf4j-log4j12", "org.slf4j");
            mavenGroupIdDatabase.put("spring-security-core", "org.springframework.security");
            mavenGroupIdDatabase.put("spring-aop", "org.springframework");
            mavenGroupIdDatabase.put("spring-beans", "org.springframework");
            mavenGroupIdDatabase.put("spring-context", "org.springframework");
            mavenGroupIdDatabase.put("spring-context-support", "org.springframework");
            mavenGroupIdDatabase.put("spring-core", "org.springframework");
            mavenGroupIdDatabase.put("spring-jdbc", "org.springframework");
            mavenGroupIdDatabase.put("spring-orm", "org.springframework");
            mavenGroupIdDatabase.put("spring-tx", "org.springframework");
            mavenGroupIdDatabase.put("oro", "oro");
            mavenGroupIdDatabase.put("poi", "poi");
            mavenGroupIdDatabase.put("stax", "stax");
            mavenGroupIdDatabase.put("stax-api", "stax");
            mavenGroupIdDatabase.put("struts-layout-psa", "struts-layout");
            mavenGroupIdDatabase.put("struts", "struts");
            mavenGroupIdDatabase.put("java-getopt", "urbanophile");
            mavenGroupIdDatabase.put("velocity", "velocity");
            mavenGroupIdDatabase.put("xalan", "xalan");
            mavenGroupIdDatabase.put("xercesImpl", "xerces");
            mavenGroupIdDatabase.put("xmlParserAPIs", "xerces");
            mavenGroupIdDatabase.put("xml-apis", "xml-apis");
            mavenGroupIdDatabase.put("xom", "xom");
        }
        return mavenGroupIdDatabase;
    }

    public static String getMode() {
        return mode;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void setMode(String mode) {
        JarContainer.mode = mode;
    }

    public JarContainer() {
    }

    public JarContainer(Class<?> origin) {
        this.addOrigin(origin);
    }

    public JarContainer(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public void addDestination(String destination) {
        this.destinations.add(destination);
    }

    public void addOrigin(Class<?> origin) {
        this.origins.add(this.buildOriginClassName(origin));
    }

    public void addOrigins(Collection<String> otherOrigins) {
        for (String otherOrigin : otherOrigins) {
            if (this.origins.contains(otherOrigin)) continue;
            this.origins.add(otherOrigin);
        }
    }

    private String buildOriginClassName(Class<?> origin) {
        String className = origin.getName();
        return className.substring(className.lastIndexOf(".") + 1, className.length());
    }

    public String buildStartConstantsRegExp() {
        return this.getJarBaseName() + ".*\\.jar";
    }

    @Override
    public int compareTo(JarContainer arg0) {
        return this.getJarName().compareTo(arg0.getJarName());
    }

    private String extractArtifactId(String jarName) {
        String artifactId = this.getJarBaseName();
        return artifactId;
    }

    private String extractVersion(String jarName) {
        String jarBaseName = this.getJarBaseName();
        String version = jarName.replaceAll(jarBaseName, "").replaceAll(".jar", "");
        if (version.startsWith("-")) {
            version = version.substring(1, version.length());
        }
        return version;
    }

    private JarContainer fusion(JarContainer similijar) {
        if (StringUtils.isEmpty((CharSequence)this.key)) {
            this.setKey(similijar.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            this.setPath(similijar.getPath());
        }
        if (this.cksum == 0) {
            this.cksum = similijar.getCksum();
        }
        if (StringUtils.isEmpty((CharSequence)this.startConstantsRegExp)) {
            this.setStartConstantsRegExp(similijar.getStartConstantsRegExp());
        }
        if (StringUtils.isEmpty((CharSequence)this.startConstantsKey)) {
            this.setStartConstantsKey(similijar.getStartConstantsKey());
        }
        if (StringUtils.isEmpty((CharSequence)this.jarName)) {
            this.setJarName(similijar.getJarName());
        }
        if (StringUtils.isEmpty((CharSequence)this.groupId)) {
            this.setGroupId(similijar.getGroupId());
        }
        if (StringUtils.isEmpty((CharSequence)this.artifactId)) {
            this.setArtifactId(similijar.getArtifactId());
        }
        if (StringUtils.isEmpty((CharSequence)this.version)) {
            this.setVersion(similijar.getVersion());
        }
        if (StringUtils.isEmpty((CharSequence)this.description)) {
            this.setDescription(similijar.getDescription());
        }
        for (String destination : similijar.getDestinationsList()) {
            this.destinations.add(destination);
        }
        for (String module : similijar.getModulesList()) {
            this.modules.add(module);
        }
        for (String origin : similijar.getOrigins()) {
            this.origins.add(origin);
        }
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public int getCksum() {
        return this.cksum;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDestinations() {
        StringBuffer sb = new StringBuffer();
        if (this.destinations != null) {
            int i = 0;
            for (String destination : this.destinations) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(destination);
            }
        }
        return sb.toString();
    }

    public Collection<String> getDestinationsList() {
        return this.destinations;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getJarBaseName() {
        String baseJarName = this.getJarName();
        if (MODE_BASENAME.equalsIgnoreCase(mode)) {
            String jarName = baseJarName.replaceAll("-SNAPSHOT", "");
            StringTokenizer st = new StringTokenizer(jarName = jarName.replaceAll(".jar", ""), "-");
            if (st.countTokens() > 0) {
                StringBuffer baseName = new StringBuffer();
                String token = "";
                for (int i = 0; i < st.countTokens(); ++i) {
                    token = st.nextToken();
                    if (i > 0) {
                        baseName.append("-");
                    }
                    baseName.append(token);
                }
                if (st.hasMoreTokens() && JarContainer.isAlpha(token = st.nextToken())) {
                    baseName.append("-").append(token);
                }
                return baseName.toString();
            }
            return jarName;
        }
        return baseJarName;
    }

    public String getJarName() {
        if (this.jarName == "" && this.artifactId != null && this.version != null) {
            this.jarName = this.artifactId + "-" + this.version + ".jar";
        }
        return this.jarName;
    }

    public String getKey() {
        return this.key;
    }

    public String getModules() {
        StringBuffer sb = new StringBuffer();
        if (this.modules != null) {
            int i = 0;
            for (String module : this.modules) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(module);
            }
        }
        return sb.toString();
    }

    public Collection<String> getModulesList() {
        return this.modules;
    }

    public Collection<String> getOrigins() {
        return this.origins;
    }

    public String getPath() {
        return this.path;
    }

    public String getStartConstantsKey() {
        return this.startConstantsKey;
    }

    public String getStartConstantsRegExp() {
        return this.startConstantsRegExp;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasOrigin(Class<?> clazz) {
        String className = this.buildOriginClassName(clazz);
        for (String origin : this.origins) {
            if (!origin.equalsIgnoreCase(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isActif() {
        return this.actif;
    }

    public void setActif(boolean actif) {
        this.actif = actif;
    }

    public void setActif(String actif) {
        this.actif = Boolean.parseBoolean(actif);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setCksum(int cksum) {
        this.cksum = cksum;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDestinations(Collection<String> destinations) {
        this.destinations = destinations;
    }

    public void setDestinations(String destination) {
        if (!StringUtils.isEmpty((CharSequence)destination)) {
            String[] dests = destination.split(",");
            this.destinations = new TreeSet<String>();
            for (String dest : dests) {
                this.destinations.add(dest.trim());
            }
        }
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
        this.setVersion(this.extractVersion(jarName));
        this.setArtifactId(this.extractArtifactId(jarName));
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setModules(Collection<String> modules) {
        this.modules = modules;
    }

    public void setModules(String modules) {
        if (!StringUtils.isEmpty((CharSequence)modules)) {
            String[] mods = modules.split(",");
            this.modules = new TreeSet<String>();
            for (String mod : mods) {
                this.modules.add(mod.trim());
            }
        }
    }

    public void setOrigin(Collection<String> origin) {
        this.origins = origin;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStartConstantsKey(String startConstantsKey) {
        this.startConstantsKey = startConstantsKey;
    }

    public void setStartConstantsRegExp(String startConstantsRegExp) {
        this.startConstantsRegExp = startConstantsRegExp;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (String className : this.origins) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(className);
        }
        return this.getJarName() + " [" + sb.toString() + "]";
    }

    static {
        mode = MODE_BASENAME;
    }
}

