/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.tensin.common.tools.boot.updater.FilenameFilterJar;
import org.tensin.sonos.SonosException;

public class ClasspathBooter {
    private static final String ADD_URL_METHOD_NAME = "addURL";
    private static final String SUFFIX_CLASS = ".class";
    private static Method addUrlMethod;
    private static URLClassLoader sysLoader;
    private boolean debug;
    private final List<String> missingJars = new ArrayList<String>();
    private final List<URL> initialJars = new ArrayList<URL>();
    private final List<String> potentialProblems = new ArrayList<String>();
    private boolean potentialproblemsChecked;
    private String jarBaseName;
    private boolean stopIfMissingJars;
    private String projectName;

    public static void dump(Collection<?> l) {
        StringBuilder sb = new StringBuilder();
        if (l == null) {
            sb.append("Uninitialized variable (null)");
        } else if (l.isEmpty()) {
            sb.append("Empty list");
        } else {
            Iterator<?> iterator = l.iterator();
            while (iterator.hasNext()) {
                sb.append(" - ").append(iterator.next().toString()).append("\n");
            }
        }
    }

    private static Method getAddUrlMethod() throws SonosException {
        if (addUrlMethod == null) {
            Class<URLClassLoader> sysClass = URLClassLoader.class;
            try {
                addUrlMethod = sysClass.getDeclaredMethod(ADD_URL_METHOD_NAME, URL.class);
                addUrlMethod.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new SonosException(e);
            }
            catch (NoSuchMethodException e) {
                throw new SonosException(e);
            }
        }
        return addUrlMethod;
    }

    public static URLClassLoader getURLClassLoader() {
        if (sysLoader == null) {
            sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        return sysLoader;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public ClasspathBooter(String jarBaseName, String projectName) {
        this.jarBaseName = jarBaseName;
        this.projectName = projectName;
        this.initialJars.addAll(Arrays.asList(ClasspathBooter.getURLClassLoader().getURLs()));
        Collections.sort(this.initialJars, new UrlComparator());
    }

    public void addAllJars() throws SonosException {
        String lib = this.getLibraryPathName(this.jarBaseName);
        if (!ClasspathBooter.isEmpty(lib)) {
            File dir = this.getLibraryPathFile(lib);
            List<File> potentialJars = this.loadJarsInPath(dir);
            this.updateCurrentClasspath(potentialJars);
        }
    }

    public void addAllJars(String pathToLoad) throws SonosException {
        if (!ClasspathBooter.isEmpty(pathToLoad)) {
            File dir = this.getLibraryPathFile(pathToLoad);
            List<File> potentialJars = this.loadJarsInPath(dir);
            this.updateCurrentClasspath(potentialJars);
        }
    }

    public void addJarsToClasspath(List<String> expectedJars) throws SonosException {
        this.addJarsToClasspath(this.getLibraryPathName(this.jarBaseName), expectedJars);
    }

    public void addJarsToClasspath(Set<String> expectedJars) throws SonosException {
        this.addJarsToClasspath(this.getLibraryPathName(this.jarBaseName), new ArrayList<String>(expectedJars));
    }

    public void addJarsToClasspath(String lib, List<String> expectedJars) throws SonosException {
        if (!ClasspathBooter.isEmpty(lib) && new File(lib.replaceAll("file:", "")).isDirectory()) {
            File dir = this.getLibraryPathFile(lib);
            List<File> potentialJars = this.loadJarsInPath(dir);
            if (potentialJars == null || potentialJars.size() == 0) {
                throw new SonosException("No jars found in path [" + dir.getAbsolutePath() + "]");
            }
            List<File> neededJars = this.loadNeededJars(dir, potentialJars, expectedJars);
            this.updateCurrentClasspath(neededJars);
        }
    }

    public void addJarsToClasspath(String lib, Set<String> expectedJars) throws SonosException {
        if (expectedJars != null && expectedJars.size() > 0) {
            this.addJarsToClasspath(lib, new ArrayList<String>(expectedJars));
        }
    }

    public void addJarsToClasspath(String lib, String[] expectedJars) throws SonosException {
        if (expectedJars != null && expectedJars.length > 0) {
            this.addJarsToClasspath(lib, Arrays.asList(expectedJars));
        }
    }

    public void addJarsToClasspath(String[] expectedJars) throws SonosException {
        if (expectedJars != null && expectedJars.length > 0) {
            this.addJarsToClasspath(this.getLibraryPathName(this.jarBaseName), expectedJars);
        }
    }

    public boolean addJarsToClasspathWithMagickDiscovery(List<String> possibleJarNames, List<String> possiblePaths) throws SonosException {
        for (String possibleJarName : possibleJarNames) {
            for (String possiblePath : possiblePaths) {
                File[] foundFiles;
                File possiblePathFile = new File(possiblePath);
                if (!possiblePathFile.exists() || !possiblePathFile.isDirectory()) continue;
                for (File foundFile2 : foundFiles = possiblePathFile.listFiles()) {
                    File foundFile = foundFile2;
                    if (!foundFile.getName().matches(possibleJarName)) continue;
                    ArrayList<File> l = new ArrayList<File>();
                    l.add(foundFile);
                    this.updateCurrentClasspath(l);
                    return true;
                }
            }
        }
        return false;
    }

    public String displayClasspath() {
        return this.displayClasspath(" ");
    }

    public String displayClasspath(String lineSeparator) {
        StringBuilder cpLog = new StringBuilder(lineSeparator);
        if (this.initialJars != null && this.initialJars.size() > 0) {
            cpLog.append("initial classpath=").append(lineSeparator);
            Iterator<URL> itr = this.initialJars.iterator();
            while (itr.hasNext()) {
                cpLog.append(" - ").append(itr.next().getPath()).append(lineSeparator);
            }
        }
        cpLog.append("dynamic classpath=").append(lineSeparator);
        ArrayList<URL> dynamicJars = new ArrayList<URL>();
        dynamicJars.addAll(Arrays.asList(ClasspathBooter.getURLClassLoader().getURLs()));
        Collections.sort(dynamicJars, new UrlComparator());
        for (URL currentJar : dynamicJars) {
            if (this.initialJars.contains(currentJar)) continue;
            cpLog.append(" - ").append(currentJar.getPath()).append(lineSeparator);
        }
        return cpLog.toString();
    }

    public String displayMissingJars() {
        StringBuffer sb = new StringBuffer();
        if (this.hasMissingJars()) {
            for (String item : this.missingJars) {
                sb.append(" - ").append(item).append("\n");
            }
        }
        return sb.toString();
    }

    public void execute(String className, String methodName) throws SonosException {
        this.execute(className, methodName, new Class[0], new Object[0]);
    }

    public void execute(String className, String methodName, Class<?>[] argsDefinitions, Object[] argsValues) throws SonosException {
        try {
            Class<?> mainClass = Class.forName(className);
            Method mainMethod = mainClass.getDeclaredMethod(methodName, argsDefinitions);
            if (Modifier.isStatic(mainMethod.getModifiers())) {
                mainMethod.invoke(null, argsValues);
            } else {
                Object o = mainClass.newInstance();
                mainMethod.invoke(o, argsValues);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SonosException(e);
        }
        catch (InstantiationException e) {
            throw new SonosException(e);
        }
        catch (IllegalAccessException e) {
            throw new SonosException(e);
        }
        catch (SecurityException e) {
            throw new SonosException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SonosException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SonosException(e);
        }
        catch (InvocationTargetException e) {
            throw new SonosException(e);
        }
    }

    private List<String> getAlreadyLoadedJar(URLClassLoader l) {
        ArrayList<String> alreadyLoadedJars = new ArrayList<String>();
        URL[] urls = l.getURLs();
        if (urls != null) {
            for (URL url : urls) {
                alreadyLoadedJars.add(url.getPath());
            }
        }
        return alreadyLoadedJars;
    }

    public String getJarBaseName() {
        return this.jarBaseName;
    }

    private File getLibraryPathFile(String lib) throws SonosException {
        File result = null;
        String libToAdd = null;
        try {
            libToAdd = lib.replaceAll("\\\\", "/");
            if (!libToAdd.startsWith("file:/")) {
                libToAdd = libToAdd.replaceAll("file:", "file:/");
            }
            result = new File(new URI(libToAdd));
        }
        catch (URISyntaxException e) {
            throw new SonosException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SonosException("URI " + libToAdd + " incorrecte", e);
        }
        return result;
    }

    public String getLibraryPathName(String containingJarName) {
        String path;
        URL startClassUrl;
        String result = null;
        URLClassLoader sysLoader = ClasspathBooter.getURLClassLoader();
        String startClass = ClasspathBooter.class.getName().replace('.', '/');
        if (sysLoader != null && (startClassUrl = sysLoader.getResource(startClass + SUFFIX_CLASS)) != null && !ClasspathBooter.isEmpty(path = startClassUrl.getPath()) && !ClasspathBooter.isEmpty(containingJarName) && path.matches(".*" + containingJarName + ".*")) {
            result = path;
            int p = result.indexOf("!");
            if (p != -1) {
                result = result.substring(0, p);
            }
            p = result.lastIndexOf("/");
            result = path.substring(0, p + 1);
        }
        return result;
    }

    public String getManifest(String jarName, String lineSeparator) {
        File[] files;
        StringBuilder sb = new StringBuilder();
        String lib = this.getLibraryPathName(this.jarBaseName);
        if (!ClasspathBooter.isEmpty(lib) && (files = new File(lib = lib.replaceAll("file:", "")).listFiles(new FilenameFilterJar())) != null && files.length > 0) {
            for (File jar : files) {
                if (!jar.getName().matches(".*" + jarName + ".*") || !jar.exists()) continue;
                try {
                    String line;
                    JarFile jarFile = new JarFile(jar);
                    JarEntry entry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
                    InputStream is = jarFile.getInputStream(entry);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        sb.append(lineSeparator).append(line);
                    }
                    if (jarFile == null) continue;
                    jarFile.close();
                    jarFile = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<File> getProvidedJarName(String regExp) throws SonosException {
        String lib = this.getLibraryPathName(this.jarBaseName);
        if (!ClasspathBooter.isEmpty(lib)) {
            File dir = this.getLibraryPathFile(lib);
            List<File> potentialJars = this.loadJarsInPath(dir);
            return this.pickCorrespondingJar(regExp, potentialJars);
        }
        return null;
    }

    public boolean hasMissingJars() {
        return this.missingJars != null && this.missingJars.size() > 0;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isStopIfMissingJars() {
        return this.stopIfMissingJars;
    }

    public List<File> loadJarsInPath(File directory) {
        ArrayList<File> result = new ArrayList<File>();
        if (directory.isDirectory()) {
            File[] listeDirectories;
            File[] liste;
            FilenameFilterJar filter = new FilenameFilterJar();
            for (File element : liste = directory.listFiles(filter)) {
                if (!element.isFile()) continue;
                result.add(element);
            }
            for (File element : listeDirectories = directory.listFiles()) {
                if (!element.isDirectory()) continue;
                result.addAll(this.loadJarsInPath(element));
            }
        }
        Collections.reverse(result);
        return result;
    }

    private List<File> loadNeededJars(File dir, List<File> potentialJars, List<String> neededJars) throws SonosException {
        ArrayList<File> result = new ArrayList<File>();
        Iterator<String> itr = neededJars.iterator();
        String regExp = null;
        StringBuffer msgFoundJars = new StringBuffer();
        int errors = 0;
        List<File> foundJars = null;
        while (itr.hasNext()) {
            regExp = itr.next();
            File f = new File(regExp);
            if (f.exists()) {
                result.add(f);
                continue;
            }
            if (regExp == null) {
                regExp = ".*";
            }
            if ((foundJars = this.pickCorrespondingJar(regExp, potentialJars)) == null || foundJars.size() == 0) {
                ++errors;
                this.registerMissingJar(regExp);
                continue;
            }
            for (File currentJar : foundJars) {
                if (!currentJar.exists()) {
                    ++errors;
                    this.registerMissingJar(regExp, currentJar.getName());
                    continue;
                }
                msgFoundJars.append("- ").append(currentJar.getName()).append("").append("\n");
                result.add(currentJar);
            }
        }
        if (errors > 0 && this.stopIfMissingJars) {
            throw new SonosException("Some expected jars are missing in the path [" + dir.getAbsolutePath() + "] : \n" + this.displayMissingJars());
        }
        return result;
    }

    private List<File> pickCorrespondingJar(String regExp, Collection<File> potentialJars) {
        ArrayList<File> result = new ArrayList<File>();
        Iterator<File> itr = potentialJars.iterator();
        String currentName = null;
        File currentFile = null;
        if (!regExp.startsWith(".*")) {
            regExp = ".*" + regExp;
        }
        if (!regExp.endsWith(".*")) {
            regExp = regExp + ".*";
        }
        while (itr.hasNext()) {
            currentFile = itr.next();
            currentName = currentFile.getAbsolutePath().replaceAll("\\\\", "/");
            if (currentName == null || !currentName.matches(regExp)) continue;
            result.add(currentFile);
            itr.remove();
        }
        return result;
    }

    private void registerMissingJar(String regExp) {
        this.missingJars.add("Missing jar [" + regExp + "]");
    }

    private void registerMissingJar(String regExp, String jarName) {
        this.missingJars.add("Missing jar [" + jarName + "] > [" + regExp + "]");
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDebug(String value) {
        String mode = System.getProperty("debug");
        if (!ClasspathBooter.isEmpty(mode) && ("on".equalsIgnoreCase(mode) || "oui".equalsIgnoreCase(mode) || "o".equalsIgnoreCase(mode) || "yes".equalsIgnoreCase(mode) || "y".equalsIgnoreCase(mode) || "1".equalsIgnoreCase(mode) || "true".equalsIgnoreCase(mode))) {
            this.debug = true;
        }
    }

    public void setJarBaseName(String jarBaseName) {
        this.jarBaseName = jarBaseName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setStopIfMissingJars(boolean stopIfMissingJars) {
        this.stopIfMissingJars = stopIfMissingJars;
    }

    protected void updateCurrentClasspath(List<File> neededJars) throws SonosException {
        File jar = null;
        Iterator<File> itr = neededJars.iterator();
        Method m = ClasspathBooter.getAddUrlMethod();
        URLClassLoader l = ClasspathBooter.getURLClassLoader();
        List<String> alreadyLoadedJars = this.getAlreadyLoadedJar(l);
        while (itr.hasNext()) {
            jar = itr.next();
            if (!jar.exists()) {
                throw new SonosException("Expected jar not found [" + jar.getAbsolutePath() + "]");
            }
            if (alreadyLoadedJars != null && alreadyLoadedJars.contains(jar.getAbsolutePath())) continue;
            try {
                m.invoke((Object)l, jar.toURL());
            }
            catch (IllegalArgumentException e) {
                throw new SonosException(e);
            }
            catch (MalformedURLException e) {
                throw new SonosException(e);
            }
            catch (IllegalAccessException e) {
                throw new SonosException(e);
            }
            catch (InvocationTargetException e) {
                throw new SonosException(e);
            }
        }
    }

    public class UrlComparator
    implements Comparator<URL> {
        @Override
        public int compare(URL u1, URL u2) {
            int ret = u1.getHost().compareTo(u2.getHost());
            if (ret != 0) {
                return ret;
            }
            ret = u1.getPath().compareTo(u2.getPath());
            if (ret != 0) {
                return ret;
            }
            ret = u1.getProtocol().compareTo(u2.getProtocol());
            if (ret != 0) {
                return ret;
            }
            if (u1.getPort() < u2.getPort()) {
                return -1;
            }
            if (u1.getPort() < u2.getPort()) {
                return 1;
            }
            return 0;
        }
    }
}

