/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commands;

import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commander.CLIController;
import org.tensin.sonos.commander.CommandExecution;
import org.tensin.sonos.commander.CommandFuture;
import org.tensin.sonos.commander.ICommandFuture;
import org.tensin.sonos.commands.CommandPoisonPill;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.control.ZonePlayer;

public class ZoneCommandExecutor
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLIController.class);
    private final Object sonosZoneLocker = new Object();
    private ZonePlayer sonosZone;
    private final String zoneName;
    private final LinkedBlockingQueue<CommandExecution> commandsQueue = new LinkedBlockingQueue();
    private boolean active = true;
    private boolean runningCommand;
    private final Object queueSemaphore = new Object();
    private final Object queueCommands = new Object();
    private int executedCommandsCount = 0;

    public ZoneCommandExecutor(String zoneName) {
        this.zoneName = zoneName;
        this.setName("SONOS-THREAD-ZONE-" + zoneName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(IZoneCommand command) {
        Object object = this.queueSemaphore;
        synchronized (object) {
            CommandFuture future = new CommandFuture();
            CommandExecution commandExecution = new CommandExecution(command, future);
            this.commandsQueue.offer(commandExecution);
        }
    }

    private void executeCommand(IZoneCommand command) {
        try {
            LOGGER.info("Executing command [" + command.getName() + "] on zone [" + this.zoneName + "]");
            ++this.executedCommandsCount;
            command.execute(this.sonosZone);
        }
        catch (SonosException e) {
            LOGGER.error("Error while executing command [" + command.getName() + "] on zone [" + this.zoneName + "]");
        }
    }

    public int getCommandLeftCount() {
        return this.commandsQueue.size();
    }

    public int getExecutedCommandsCount() {
        return this.executedCommandsCount;
    }

    public ZonePlayer getSonosZone() {
        return this.sonosZone;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void halt() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNoCommandLeft() {
        Object object = this.queueSemaphore;
        synchronized (object) {
            return this.commandsQueue.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRunningCommand() {
        Object object = this.queueCommands;
        synchronized (object) {
            return this.runningCommand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerZoneAsAvailable(ZonePlayer sonos) {
        Object object = this.sonosZoneLocker;
        synchronized (object) {
            this.sonosZone = sonos;
            this.sonosZoneLocker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = this.sonosZoneLocker;
            synchronized (object) {
                if (this.sonosZone == null) {
                    this.sonosZoneLocker.wait();
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted", (Throwable)e);
        }
        while (this.active) {
            try {
                CommandExecution commandExecution = this.commandsQueue.take();
                IZoneCommand command = commandExecution.getCommand();
                ICommandFuture future = commandExecution.getFuture();
                Object object = this.queueCommands;
                synchronized (object) {
                    try {
                        this.runningCommand = true;
                        if (command != null) {
                            if (command instanceof CommandPoisonPill) {
                                this.active = false;
                            } else {
                                this.executeCommand(command);
                            }
                        }
                    }
                    finally {
                        this.runningCommand = false;
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted", (Throwable)e);
            }
        }
    }
}

