/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.control.AVTransportListener;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.SonosActionInvocation;
import org.tensin.sonos.helpers.TimeUtilities;
import org.tensin.sonos.model.AlarmProperties;
import org.tensin.sonos.model.DeviceCapabilities;
import org.tensin.sonos.model.Entry;
import org.tensin.sonos.model.MediaInfo;
import org.tensin.sonos.model.PlayMode;
import org.tensin.sonos.model.PositionInfo;
import org.tensin.sonos.model.SeekTarget;
import org.tensin.sonos.model.TrackMetaData;
import org.tensin.sonos.model.TransportAction;
import org.tensin.sonos.model.TransportInfo;
import org.tensin.sonos.model.TransportSettings;
import org.tensin.sonos.xml.AVTransportEventHandler;
import org.tensin.sonos.xml.ResultParser;
import org.xml.sax.SAXException;

public class AVTransportService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AVTransportService.class);
    private static final String SET_AV_TRANSPORT_URI_ACTION = "SetAVTransportURI";
    private static final String PLAY_ACTION = "Play";
    private static final MessageFormat METADATA_FORMAT = new MessageFormat("<DIDL-Lite xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" xmlns:r=\"urn:schemas-rinconnetworks-com:metadata-1-0/\" xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\"><item id=\"{0}\" parentID=\"{1}\" restricted=\"true\"><dc:title>{2}</dc:title><upnp:class>{3}</upnp:class><desc id=\"cdudn\" nameSpace=\"urn:schemas-rinconnetworks-com:metadata-1-0/\">RINCON_AssociatedZPUDN</desc></item></DIDL-Lite>");
    private final Map<AVTransportEventHandler.AVTransportEventType, String> state = new HashMap<AVTransportEventHandler.AVTransportEventType, String>();
    private final List<AVTransportListener> listeners = new ArrayList<AVTransportListener>();

    private static String compileMetadataString(Entry entry) {
        String upnpClass;
        if (entry.getUpnpClass().equals("object.container.radioContainer") || entry.getUpnpClass().equals("object.container.lineInContainer")) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("compileMetadataString() called on inappropriate entry " + entry);
            }
            return "";
        }
        if (entry.getUpnpClass().equals("object.item.audioItem.audioBroadcast")) {
            // empty if block
        }
        if (entry.getUpnpClass().equals("object.item.audioItem")) {
            // empty if block
        }
        if ((upnpClass = entry.getUpnpClass()).startsWith("object.container")) {
            upnpClass = "object.container";
        }
        String metadata = METADATA_FORMAT.format(new Object[]{entry.getId(), entry.getParentId(), entry.getTitle(), upnpClass});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created metadata: " + metadata);
        }
        return metadata;
    }

    protected AVTransportService(UpnpService upnpService, Service service) {
        super(upnpService, service, "urn:schemas-upnp-org:service:AVTransport:1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAvTransportListener(AVTransportListener l) {
        List<AVTransportListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public int addToQueue(Entry entry) {
        return this.addToQueue(entry, -2);
    }

    public int addToQueue(Entry entry, int position) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "AddURIToQueue");
        message.setInput("InstanceID", "0");
        message.setInput("EnqueuedURI", entry.getRes());
        message.setInput("EnqueuedURIMetaData", AVTransportService.compileMetadataString(entry));
        message.setInput("DesiredFirstTrackNumberEnqueued", String.valueOf(position + 1));
        message.setInput("EnqueueAsNext", "1");
        this.executeImmediate(message);
        return Integer.parseInt(message.getOutputAsString("FirstTrackNumberEnqueued")) - 1;
    }

    public void becomeCoordinatorOfStandaloneGroup() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "BecomeCoordinatorOfStandaloneGroup");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }

    public void becomeGroupCoordinator(String currentCoordinator, String currentGroupId, String otherMemebers, String transportSettings, String currentURI, String currentURIMetadata, String sleepTimerState, String alarmState, String streamRestartState, String currentQueueTrackList) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "BecomeGroupCoordinator");
        message.setInput("InstanceID", "0");
        message.setInput("CurrentCoordinator", currentCoordinator);
        message.setInput("CurrentGroupID", currentGroupId);
        message.setInput("OtherMembers", otherMemebers);
        message.setInput("TransportSettings", transportSettings);
        message.setInput("CurrentURI", currentURI);
        message.setInput("CurrentURIMetaData", currentURIMetadata);
        message.setInput("SleepTimerState", sleepTimerState);
        message.setInput("AlarmState", alarmState);
        message.setInput("StreamRestartState", streamRestartState);
        message.setInput("CurrentQueueTrackList", currentQueueTrackList);
        this.execute(message);
    }

    public void becomeGroupCoordinatorAndSource(String currentCoordinator, String currentGroupId, String otherMemebers, String currentURI, String currentURIMetadata, String sleepTimerState, String alarmState, String streamRestartState, String currentAVTTrackList, String currentQueueTrackList, String currentSourceState, String resumePlayback) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "BecomeGroupCoordinatorAndSource");
        message.setInput("InstanceID", "0");
        message.setInput("CurrentCoordinator", currentCoordinator);
        message.setInput("CurrentGroupID", currentGroupId);
        message.setInput("OtherMembers", otherMemebers);
        message.setInput("CurrentURI", currentURI);
        message.setInput("CurrentURIMetaData", currentURIMetadata);
        message.setInput("SleepTimerState", sleepTimerState);
        message.setInput("AlarmState", alarmState);
        message.setInput("StreamRestartState", streamRestartState);
        message.setInput("CurrentAVTTrackList", currentAVTTrackList);
        message.setInput("CurrentQueueTrackList", currentQueueTrackList);
        message.setInput("CurrentSourceState", currentSourceState);
        message.setInput("ResumePlayback", resumePlayback);
        this.execute(message);
    }

    public void changeCoordinator(String currentCoordinator, String newCoordinator, String newTransportSettings) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "ChangeCoordinator");
        message.setInput("InstanceID", "0");
        message.setInput("CurrentCoordinator", currentCoordinator);
        message.setInput("NewCoordinator", newCoordinator);
        message.setInput("NewTransportSettings", newTransportSettings);
        this.execute(message);
    }

    public void changeTransportSettings(String newTransportSettings) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "ChangeTransportSettings");
        message.setInput("InstanceID", "0");
        message.setInput("NewTransportSettings", newTransportSettings);
        this.execute(message);
    }

    public void clearQueue() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "RemoveAllTracksFromQueue");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }

    public void configureSleepTimer(int newSleepTimerDuration) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "ConfigureSleepTimer");
        message.setInput("InstanceID", "0");
        message.setInput("NewSleepTimerDuration", TimeUtilities.convertLongToDuration(newSleepTimerDuration));
        this.execute(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(Set<AVTransportEventHandler.AVTransportEventType> name) {
        List<AVTransportListener> list = this.listeners;
        synchronized (list) {
            for (AVTransportListener l : this.listeners) {
                l.valuesChanged(name, this);
            }
        }
    }

    public Collection<TransportAction> getCurrentTransportActions() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetCurrentTransportActions");
        message.setInput("InstanceID", "0");
        this.executeImmediate(message);
        String actionList = message.getOutputAsString("Actions");
        ArrayList<TransportAction> actions = new ArrayList<TransportAction>();
        for (TransportAction action : TransportAction.values()) {
            if (!actionList.contains(action.toString())) continue;
            actions.add(action);
        }
        return actions;
    }

    public DeviceCapabilities getDeviceCapabilities() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetDeviceCapabilities");
        message.setInput("InstanceID", "0");
        this.executeImmediate(message);
        return new DeviceCapabilities(message.getOutputAsString("PlayMedia"), message.getOutputAsString("RecMedia"), message.getOutputAsString("RecQualityModes"));
    }

    public MediaInfo getMediaInfo() throws SonosException {
        if (!(this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.NumberOfTracks) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.CurrentTrackDuration) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.AVTransportURI) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.AVTransportURIMetaData) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.NextAVTransportURI) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.NextAVTransportURIMetaData) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.PlaybackStorageMedium) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.RecordStorageMedium) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.RecordMediumWriteStatus))) {
            SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetMediaInfo");
            message.setInput("InstanceID", "0");
            this.executeImmediate(message);
            this.state.put(AVTransportEventHandler.AVTransportEventType.NumberOfTracks, message.getOutputAsString("NrTracks"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.CurrentTrackDuration, message.getOutputAsString("MediaDuration"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.AVTransportURI, message.getOutputAsString("CurrentURI"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.AVTransportURIMetaData, message.getOutputAsString("CurrentURIMetaData"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.NextAVTransportURI, message.getOutputAsString("NextURI"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.NextAVTransportURIMetaData, message.getOutputAsString("NextURIMetaData"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.PlaybackStorageMedium, message.getOutputAsString("PlayMedium"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.RecordStorageMedium, message.getOutputAsString("RecordMedium"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.RecordMediumWriteStatus, message.getOutputAsString("WriteStatus"));
        }
        TrackMetaData trackMetaData = null;
        try {
            String metaDataString = this.state.get((Object)AVTransportEventHandler.AVTransportEventType.AVTransportURIMetaData);
            trackMetaData = metaDataString.length() == 0 ? null : ResultParser.parseTrackMetaData(metaDataString);
        }
        catch (NullPointerException e) {
        }
        catch (SAXException e) {
            throw new SonosException(e);
        }
        return new MediaInfo(this.state.get((Object)AVTransportEventHandler.AVTransportEventType.NumberOfTracks), TimeUtilities.convertDurationToLong(this.state.get((Object)AVTransportEventHandler.AVTransportEventType.CurrentTrackDuration)), this.state.get((Object)AVTransportEventHandler.AVTransportEventType.AVTransportURI), trackMetaData, this.state.get((Object)AVTransportEventHandler.AVTransportEventType.NextAVTransportURI), this.state.get((Object)AVTransportEventHandler.AVTransportEventType.NextAVTransportURIMetaData), this.state.get((Object)AVTransportEventHandler.AVTransportEventType.PlaybackStorageMedium), this.state.get((Object)AVTransportEventHandler.AVTransportEventType.RecordStorageMedium), this.state.get((Object)AVTransportEventHandler.AVTransportEventType.RecordMediumWriteStatus));
    }

    public PositionInfo getPositionInfo() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetPositionInfo");
        message.setInput("InstanceID", "0");
        this.executeImmediate(message);
        this.state.put(AVTransportEventHandler.AVTransportEventType.CurrentTrack, message.getOutputAsString("Track"));
        this.state.put(AVTransportEventHandler.AVTransportEventType.CurrentTrackDuration, message.getOutputAsString("TrackDuration"));
        this.state.put(AVTransportEventHandler.AVTransportEventType.CurrentTrackMetaData, message.getOutputAsString("TrackMetaData"));
        this.state.put(AVTransportEventHandler.AVTransportEventType.CurrentTrackURI, message.getOutputAsString("TrackURI"));
        TrackMetaData trackMetaData = null;
        try {
            String metaDataString = this.state.get((Object)AVTransportEventHandler.AVTransportEventType.CurrentTrackMetaData);
            trackMetaData = metaDataString.length() == 0 ? null : ResultParser.parseTrackMetaData(metaDataString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PositionInfo(Integer.parseInt(this.state.get((Object)AVTransportEventHandler.AVTransportEventType.CurrentTrack)), TimeUtilities.convertDurationToLong(this.state.get((Object)AVTransportEventHandler.AVTransportEventType.CurrentTrackDuration)), trackMetaData, this.state.get((Object)AVTransportEventHandler.AVTransportEventType.CurrentTrackURI), TimeUtilities.convertDurationToLong(message.getOutputAsString("RelTime")), TimeUtilities.convertDurationToLong(message.getOutputAsString("AbsTime")), Integer.parseInt(message.getOutputAsString("RelCount")), Integer.parseInt(message.getOutputAsString("AbsCount")));
    }

    public long getRemainingSleepTimerDuration() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetRemainingSleepTimerDuration");
        message.setInput("InstanceID", "0");
        this.executeImmediate(message);
        return TimeUtilities.convertDurationToLong(message.getOutputAsString("RemainingSleepTimerDuration"));
    }

    public AlarmProperties getRunningAlarmProperties() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "RunAlarm");
        message.setInput("InstanceID", "0");
        this.executeImmediate(message);
        return new AlarmProperties(Integer.parseInt(message.getOutputAsString("AlarmID")), Integer.parseInt(message.getOutputAsString("GroupID")), TimeUtilities.convertISO8601DateToLong(message.getOutputAsString("LoggedStartTime")));
    }

    public TransportInfo getTransportInfo() {
        if (!(this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.TransportState) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.TransportStatus) && this.state.containsKey((Object)AVTransportEventHandler.AVTransportEventType.TransportPlaySpeed))) {
            SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetTransportInfo");
            message.setInput("InstanceID", "0");
            this.executeImmediate(message);
            this.state.put(AVTransportEventHandler.AVTransportEventType.TransportState, message.getOutputAsString("CurrentTransportState"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.TransportStatus, message.getOutputAsString("CurrentTransportStatus"));
            this.state.put(AVTransportEventHandler.AVTransportEventType.TransportPlaySpeed, message.getOutputAsString("CurrentSpeed"));
        }
        return new TransportInfo(this.state.get((Object)AVTransportEventHandler.AVTransportEventType.TransportState), this.state.get((Object)AVTransportEventHandler.AVTransportEventType.TransportStatus), this.state.get((Object)AVTransportEventHandler.AVTransportEventType.TransportPlaySpeed));
    }

    public TransportSettings getTransportSettings() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetTransportSettings");
        message.setInput("InstanceID", "0");
        this.executeImmediate(message);
        return new TransportSettings(message.getOutputAsString("PlayMode"), message.getOutputAsString("RecQualityMode"));
    }

    public void handleStateVariableEvent(String varName, String newValue) {
        LOGGER.debug("recieved AVTransport notification: " + varName + "=" + newValue);
        try {
            Map<AVTransportEventHandler.AVTransportEventType, String> changes = ResultParser.parseAVTransportEvent(newValue);
            this.state.putAll(changes);
            this.fireStateChanged(changes.keySet());
        }
        catch (SAXException e) {
            LOGGER.error("Could not parse change event: ", (Throwable)e);
        }
    }

    public void next() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "Next");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }

    public void nextSection() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "NextSection");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }

    public void pause() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "Pause");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }

    public void play() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), PLAY_ACTION);
        message.setInput("InstanceID", "0");
        message.setInput("Speed", "1");
        this.execute(message);
    }

    public void previous() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "Previous");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }

    public void previousSection() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "PreviousSection");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAvTransportListener(AVTransportListener l) {
        List<AVTransportListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public void removeTrackFromQueue(Entry entry) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "RemoveTrackFromQueue");
        message.setInput("InstanceID", "0");
        message.setInput("ObjectID", entry.getId());
        this.execute(message);
    }

    public void reorderTracksInQueue(int startAt, int num, int insertBefore) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "ReorderTracksInQueue");
        message.setInput("InstanceID", "0");
        message.setInput("StartingIndex", String.valueOf(startAt + 1));
        message.setInput("NumberOfTracks", String.valueOf(num));
        message.setInput("InsertBefore", String.valueOf(insertBefore + 1));
        this.execute(message);
    }

    public void runAlarm(int alarmId, long loggedStartTime, long duration, String programUri, String programMetadata, PlayMode playMode, int volume, boolean includeLinkedZones) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "RunAlarm");
        message.setInput("InstanceID", "0");
        message.setInput("AlarmID", String.valueOf(alarmId));
        message.setInput("LoggedStartTime", TimeUtilities.convertLongToISO8601Date(loggedStartTime));
        message.setInput("Duration", String.valueOf(duration));
        message.setInput("ProgramURI", programUri);
        message.setInput("ProgramMetaData", programMetadata);
        message.setInput("PlayMode", (Object)playMode);
        message.setInput("Volume", String.valueOf(volume));
        message.setInput("IncludeLinkedZones", includeLinkedZones ? "1" : "0");
        this.execute(message);
    }

    public String saveQueue(String title, String queue) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SaveQueue");
        message.setInput("InstanceID", "0");
        message.setInput("Title", title);
        message.setInput("ObjectID", queue);
        this.executeImmediate(message);
        return message.getOutputAsString("AssignedObjectID");
    }

    public void seek(SeekTarget target) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "Seek");
        message.setInput("InstanceID", "0");
        message.setInput("Unit", target.getSeekMode());
        message.setInput("Target", target.getTarget());
        this.execute(message);
    }

    public void setAvTransportUri(Entry entry) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), SET_AV_TRANSPORT_URI_ACTION);
        message.setInput("InstanceID", "0");
        message.setInput("CurrentURI", entry.getRes());
        String metadata = AVTransportService.compileMetadataString(entry);
        message.setInput("CurrentURIMetaData", metadata);
        LOGGER.debug("SetAvTransportURI(0," + entry.getRes() + "," + metadata + ")");
        this.execute(message);
    }

    public void setAvTransportUriToQueue(String zoneId) {
        this.setAvTransportUri(new Entry("", "", "", "", "", "", "", "x-rincon-queue:" + zoneId + "#0", ""));
    }

    public void setPlayMode(PlayMode mode) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetPlayMode");
        message.setInput("InstanceID", "0");
        message.setInput("NewPlayMode", mode.toString());
        this.execute(message);
    }

    public void snoozeAlarm(long duration) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SnoozeAlarm");
        message.setInput("InstanceID", "0");
        message.setInput("Duration", TimeUtilities.convertLongToISO8601Duration(duration));
        this.execute(message);
    }

    public void stop() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "Stop");
        message.setInput("InstanceID", "0");
        this.execute(message);
    }
}

