/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.tensin.sonos.control.AVTransportService;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.ConnectionManagerService;
import org.tensin.sonos.control.RenderingControlService;

public class MediaRendererDevice {
    private final RemoteDevice dev;
    private final RenderingControlService renderingControl;
    private final ConnectionManagerService connectionManager;
    private final AVTransportService avTransport;

    protected MediaRendererDevice(UpnpService upnpService, RemoteDevice dev) {
        if (dev != null && dev.getType() != null && !dev.getType().toString().equals("urn:schemas-upnp-org:device:MediaRenderer:1")) {
            throw new IllegalArgumentException("Device must be media renderer, not " + dev.getType());
        }
        this.dev = dev;
        this.renderingControl = new RenderingControlService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:RenderingControl:1"));
        this.connectionManager = new ConnectionManagerService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:ConnectionManager:1"));
        this.avTransport = new AVTransportService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:AVTransport:1"));
    }

    public void dispose() {
        this.renderingControl.dispose();
        this.connectionManager.dispose();
        this.avTransport.dispose();
    }

    public AVTransportService getAvTransportService() {
        return this.avTransport;
    }

    public ConnectionManagerService getConnectionManagerService() {
        return this.connectionManager;
    }

    public RenderingControlService getRenderingControlService() {
        return this.renderingControl;
    }

    public RemoteDevice getUPNPDevice() {
        return this.dev;
    }
}

