/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import java.util.ArrayList;
import java.util.List;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.SonosActionInvocation;
import org.tensin.sonos.control.ZoneGroupTopologyListener;
import org.tensin.sonos.model.UnresponsiveDeviceActionType;
import org.tensin.sonos.model.UpdateType;
import org.tensin.sonos.model.ZoneGroupState;

public class ZoneGroupTopologyService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZoneGroupTopologyService.class);
    private final List<ZoneGroupTopologyListener> listeners = new ArrayList<ZoneGroupTopologyListener>();
    private final ZoneGroupState zoneGroup = null;

    public ZoneGroupTopologyService(UpnpService upnpService, Service service) {
        super(upnpService, service, "urn:schemas-upnp-org:service:ZoneGroupTopology:1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZoneGroupTopologyListener(ZoneGroupTopologyListener l) {
        List<ZoneGroupTopologyListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public void beginSoftwareUpdate(String updateUrl, int updateFlags) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "BeginSoftwareUpdate");
        message.setInput("UpdateURL", updateUrl);
        message.setInput("Flags", updateFlags);
        this.execute(message);
    }

    public String checkForUpdate(UpdateType type, boolean cachedOnly, String version) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "CheckForUpdate");
        message.setInput("UpdateType", (Object)type);
        message.setInput("CachedOnly", cachedOnly);
        message.setInput("Version", version);
        this.executeImmediate(message);
        return message.getOutputAsString("UpdateItem");
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        List<ZoneGroupTopologyListener> list = this.listeners;
        synchronized (list) {
            for (ZoneGroupTopologyListener l : this.listeners) {
                l.zoneGroupTopologyChanged(this.getGroupState());
            }
        }
    }

    public ZoneGroupState getGroupState() {
        if (this.zoneGroup != null) {
            return this.zoneGroup;
        }
        return this.zoneGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeZoneGroupTopologyListener(ZoneGroupTopologyListener l) {
        List<ZoneGroupTopologyListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public void reportUnresponsiveDevice(String deviceUuid, UnresponsiveDeviceActionType action) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "ReportUnresponsiveDevice");
        message.setInput("DeviceUUID", deviceUuid);
        message.setInput("DesiredAction", (Object)action);
        this.execute(message);
    }
}

