/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.model;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.control.ZonePlayer;

public class Entry
implements Serializable,
Comparable<Entry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Entry.class);
    private static final long serialVersionUID = 1987394879345L;
    private final String id;
    private final String title;
    private final String parentId;
    private final String upnpClass;
    private final String res;
    private final String album;
    private final String albumArtUri;
    private final String albumArtist;
    private final String creator;
    private final int originalTrackNumber;

    public Entry(String id, String title, String parentId, String album, String albumArtUri, String creator, String upnpClass, String res, int originalTrackNumber, String albumArtist) {
        this.id = id;
        this.title = title;
        this.parentId = parentId;
        this.album = album;
        this.albumArtist = albumArtist;
        this.albumArtUri = albumArtUri;
        this.creator = creator;
        this.upnpClass = upnpClass;
        this.res = res;
        this.originalTrackNumber = originalTrackNumber;
    }

    public Entry(String id, String title, String parentId, String album, String albumArtUri, String creator, String upnpClass, String res, String albumArtist) {
        this(id, title, parentId, album, albumArtUri, creator, upnpClass, res, -1, albumArtist);
    }

    @Override
    public int compareTo(Entry o) {
        return new CompareToBuilder().append((Object)this.getTitle(), (Object)o.getTitle()).append((Object)this.getAlbum(), (Object)o.getAlbum()).append((Object)this.getCreator(), (Object)o.getCreator()).append(this.getOriginalTrackNumber(), o.getOriginalTrackNumber()).append((Object)this.getAlbumArtUri(), (Object)o.getAlbumArtUri()).build();
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public String getAlbumArtUri() {
        return StringEscapeUtils.unescapeXml((String)this.albumArtUri);
    }

    public URL getAlbumArtURL(ZonePlayer zp) throws MalformedURLException {
        String uri = this.getAlbumArtUri();
        if (uri.startsWith("/getAA")) {
            LOGGER.info("uri = " + uri);
        }
        return zp.appendUrl(uri);
    }

    public String getCreator() {
        return this.creator;
    }

    public String getId() {
        return this.id;
    }

    public int getOriginalTrackNumber() {
        return this.originalTrackNumber;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getRes() {
        return this.res;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUpnpClass() {
        return this.upnpClass;
    }

    public String toString() {
        return this.title;
    }
}

