/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import com.sun.javafx.css.StyleManager;
import impl.org.controlsfx.ImplUtils;
import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BooleanSupplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.stage.Window;
import org.controlsfx.tools.ValueExtractor;
import org.controlsfx.validation.ValidationSupport;

public class Wizard {
    private Dialog<ButtonType> dialog;
    private final ObservableMap<String, Object> settings = FXCollections.observableHashMap();
    private final Stack<WizardPane> pageHistory = new Stack();
    private Optional<WizardPane> currentPage = Optional.empty();
    private final ValidationSupport validationSupport = new ValidationSupport();
    private final ButtonType BUTTON_PREVIOUS = new ButtonType(Localization.localize(Localization.asKey("wizard.previous.button")), ButtonBar.ButtonData.BACK_PREVIOUS);
    private final EventHandler<ActionEvent> BUTTON_PREVIOUS_ACTION_HANDLER = actionEvent -> {
        actionEvent.consume();
        this.currentPage = Optional.ofNullable(this.pageHistory.isEmpty() ? null : this.pageHistory.pop());
        this.updatePage(this.dialog, false);
    };
    private final ButtonType BUTTON_NEXT = new ButtonType(Localization.localize(Localization.asKey("wizard.next.button")), ButtonBar.ButtonData.NEXT_FORWARD);
    private final EventHandler<ActionEvent> BUTTON_NEXT_ACTION_HANDLER = actionEvent -> {
        actionEvent.consume();
        this.currentPage.ifPresent(page -> this.pageHistory.push((WizardPane)((Object)((Object)page))));
        this.currentPage = this.getFlow().advance(this.currentPage.orElse(null));
        this.updatePage(this.dialog, true);
    };
    private final StringProperty titleProperty = new SimpleStringProperty();
    private ObjectProperty<Flow> flow = new SimpleObjectProperty<Flow>((Flow)new LinearFlow(new WizardPane[0])){

        protected void invalidated() {
            Wizard.this.updatePage((Dialog<ButtonType>)Wizard.this.dialog, false);
        }

        public void set(Flow flow) {
            super.set((Object)flow);
            Wizard.this.pageHistory.clear();
            if (flow != null) {
                Wizard.this.currentPage = flow.advance(Wizard.this.currentPage.orElse(null));
                Wizard.this.updatePage((Dialog<ButtonType>)Wizard.this.dialog, true);
            }
        }
    };
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private int settingCounter;

    public Wizard() {
        this(null);
    }

    public Wizard(Object owner) {
        this(owner, "");
    }

    public Wizard(Object owner, String title) {
        this.validationSupport.validationResultProperty().addListener((o, ov, nv) -> this.validateActionState());
        this.dialog = new Dialog();
        this.dialog.titleProperty().bind((ObservableValue)this.titleProperty);
        this.setTitle(title);
        Window window = null;
        if (owner instanceof Window) {
            window = (Window)owner;
        } else if (owner instanceof Node) {
            window = ((Node)owner).getScene().getWindow();
        }
        this.dialog.initOwner(window);
    }

    public final Optional<ButtonType> showAndWait() {
        return this.dialog.showAndWait();
    }

    public final ObservableMap<String, Object> getSettings() {
        return this.settings;
    }

    public final StringProperty titleProperty() {
        return this.titleProperty;
    }

    public final String getTitle() {
        return (String)this.titleProperty.get();
    }

    public final void setTitle(String title) {
        this.titleProperty.set((Object)title);
    }

    public final ObjectProperty<Flow> flowProperty() {
        return this.flow;
    }

    public final Flow getFlow() {
        return (Flow)this.flow.get();
    }

    public final void setFlow(Flow flow) {
        this.flow.set((Object)flow);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public ValidationSupport getValidationSupport() {
        return this.validationSupport;
    }

    private void updatePage(Dialog<ButtonType> dialog, boolean advancing) {
        Flow flow = this.getFlow();
        if (flow == null) {
            return;
        }
        Optional<Object> prevPage = Optional.ofNullable(this.pageHistory.isEmpty() ? null : this.pageHistory.peek());
        prevPage.ifPresent(page -> {
            if (advancing) {
                this.readSettings((WizardPane)((Object)page));
            }
            page.onExitingPage(this);
        });
        this.currentPage.ifPresent(currentPage -> {
            Button button;
            ObservableList buttons = currentPage.getButtonTypes();
            if (!buttons.contains(this.BUTTON_PREVIOUS)) {
                buttons.add(this.BUTTON_PREVIOUS);
                button = (Button)currentPage.lookupButton(this.BUTTON_PREVIOUS);
                button.addEventFilter(ActionEvent.ACTION, this.BUTTON_PREVIOUS_ACTION_HANDLER);
            }
            if (!buttons.contains(this.BUTTON_NEXT)) {
                buttons.add(this.BUTTON_NEXT);
                button = (Button)currentPage.lookupButton(this.BUTTON_NEXT);
                button.addEventFilter(ActionEvent.ACTION, this.BUTTON_NEXT_ACTION_HANDLER);
            }
            if (!buttons.contains(ButtonType.FINISH)) {
                buttons.add(ButtonType.FINISH);
            }
            if (!buttons.contains(ButtonType.CANCEL)) {
                buttons.add(ButtonType.CANCEL);
            }
            currentPage.onEnteringPage(this);
            dialog.setDialogPane((DialogPane)currentPage);
        });
        this.validateActionState();
    }

    private void validateActionState() {
        ObservableList currentPaneButtons = this.dialog.getDialogPane().getButtonTypes();
        if (!this.getFlow().canAdvance(this.currentPage.orElse(null))) {
            currentPaneButtons.remove(this.BUTTON_NEXT);
        } else {
            if (currentPaneButtons.contains(this.BUTTON_NEXT)) {
                currentPaneButtons.remove(this.BUTTON_NEXT);
                currentPaneButtons.add(0, this.BUTTON_NEXT);
                Button button = (Button)this.dialog.getDialogPane().lookupButton(this.BUTTON_NEXT);
                button.addEventFilter(ActionEvent.ACTION, this.BUTTON_NEXT_ACTION_HANDLER);
            }
            currentPaneButtons.remove(ButtonType.FINISH);
        }
        this.validateButton(this.BUTTON_PREVIOUS, () -> this.pageHistory.isEmpty());
        this.validateButton(this.BUTTON_NEXT, () -> this.validationSupport.isInvalid());
    }

    private void validateButton(ButtonType buttonType, BooleanSupplier condition) {
        Button btn = (Button)this.dialog.getDialogPane().lookupButton(buttonType);
        if (btn != null) {
            btn.setDisable(condition.getAsBoolean());
        }
    }

    private void readSettings(WizardPane page) {
        this.settingCounter = 0;
        this.checkNode(page.getContent());
    }

    private boolean checkNode(Node n) {
        boolean success = this.readSetting(n);
        if (success) {
            return true;
        }
        List<Node> children = ImplUtils.getChildren(n, false);
        boolean childSuccess = false;
        for (Node child : children) {
            childSuccess |= this.checkNode(child);
        }
        return childSuccess;
    }

    private boolean readSetting(Node n) {
        if (n == null) {
            return false;
        }
        Object setting = ValueExtractor.getValue(n);
        if (setting != null) {
            String settingName = n.getId();
            if (settingName == null || settingName.isEmpty()) {
                settingName = "page_.setting_" + this.settingCounter;
            }
            this.getSettings().put((Object)settingName, setting);
            ++this.settingCounter;
        }
        return setting != null;
    }

    static {
        StyleManager.getInstance().addUserAgentStylesheet(Wizard.class.getResource("wizard.css").toExternalForm());
        USER_DATA_KEY = new Object();
    }

    public static class LinearFlow
    implements Flow {
        private final List<WizardPane> pages;

        public LinearFlow(Collection<WizardPane> pages) {
            this.pages = new ArrayList<WizardPane>(pages);
        }

        public LinearFlow(WizardPane ... pages) {
            this(Arrays.asList(pages));
        }

        @Override
        public Optional<WizardPane> advance(WizardPane currentPage) {
            int pageIndex = this.pages.indexOf((Object)currentPage);
            return Optional.ofNullable(this.pages.get(++pageIndex));
        }

        @Override
        public boolean canAdvance(WizardPane currentPage) {
            int pageIndex = this.pages.indexOf((Object)currentPage);
            return this.pages.size() - 1 > pageIndex;
        }
    }

    public static interface Flow {
        public Optional<WizardPane> advance(WizardPane var1);

        public boolean canAdvance(WizardPane var1);
    }

    public static class WizardPane
    extends DialogPane {
        public WizardPane() {
            this.getStyleClass().add((Object)"wizard-pane");
        }

        public void onEnteringPage(Wizard wizard) {
        }

        public void onExitingPage(Wizard wizard) {
        }
    }
}

