/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.meta;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.Namespace;
import org.fourthline.cling.model.Validatable;
import org.fourthline.cling.model.ValidationError;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.meta.Action;
import org.fourthline.cling.model.meta.DeviceDetails;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.Icon;
import org.fourthline.cling.model.meta.ModelDetails;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.meta.StateVariable;
import org.fourthline.cling.model.meta.UDAVersion;
import org.fourthline.cling.model.profile.RemoteClientInfo;
import org.fourthline.cling.model.resource.Resource;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceId;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;

public abstract class Device<DI extends DeviceIdentity, D extends Device, S extends Service>
implements Validatable {
    private static final Logger log = Logger.getLogger(Device.class.getName());
    private final DI identity;
    private final UDAVersion version;
    private final DeviceType type;
    private final DeviceDetails details;
    private final Icon[] icons;
    protected final S[] services;
    protected final D[] embeddedDevices;
    private D parentDevice;

    public Device(DI identity) throws ValidationException {
        this((DeviceIdentity)identity, null, null, null, null, null);
    }

    public Device(DI identity, DeviceType type, DeviceDetails details, Icon[] icons, S[] services) throws ValidationException {
        this((DeviceIdentity)identity, null, type, details, icons, (Service[])services, null);
    }

    public Device(DI identity, DeviceType type, DeviceDetails details, Icon[] icons, S[] services, D[] embeddedDevices) throws ValidationException {
        this((DeviceIdentity)identity, null, type, details, icons, (Service[])services, (Device[])embeddedDevices);
    }

    public Device(DI identity, UDAVersion version, DeviceType type, DeviceDetails details, Icon[] icons, S[] services, D[] embeddedDevices) throws ValidationException {
        this.identity = identity;
        this.version = version == null ? new UDAVersion() : version;
        this.type = type;
        this.details = details;
        ArrayList<Icon> validIcons = new ArrayList<Icon>();
        if (icons != null) {
            for (Icon icon : icons) {
                if (icon == null) continue;
                icon.setDevice(this);
                List<ValidationError> iconErrors = icon.validate();
                if (iconErrors.isEmpty()) {
                    validIcons.add(icon);
                    continue;
                }
                log.warning("Discarding invalid '" + icon + "': " + iconErrors);
            }
        }
        this.icons = validIcons.toArray(new Icon[validIcons.size()]);
        boolean allNullServices = true;
        if (services != null) {
            for (S service : services) {
                if (service == null) continue;
                allNullServices = false;
                ((Service)service).setDevice((Device)this);
            }
        }
        this.services = services == null || allNullServices ? null : services;
        boolean allNullEmbedded = true;
        if (embeddedDevices != null) {
            for (Device embeddedDevice : embeddedDevices) {
                if (embeddedDevice == null) continue;
                allNullEmbedded = false;
                embeddedDevice.setParentDevice((Device)this);
            }
        }
        this.embeddedDevices = embeddedDevices == null || allNullEmbedded ? null : embeddedDevices;
        List<ValidationError> errors = this.validate();
        if (errors.size() > 0) {
            if (log.isLoggable(Level.FINEST)) {
                for (ValidationError error : errors) {
                    log.finest(error.toString());
                }
            }
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", errors);
        }
    }

    public DI getIdentity() {
        return this.identity;
    }

    public UDAVersion getVersion() {
        return this.version;
    }

    public DeviceType getType() {
        return this.type;
    }

    public DeviceDetails getDetails() {
        return this.details;
    }

    public DeviceDetails getDetails(RemoteClientInfo info) {
        return this.getDetails();
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public boolean hasIcons() {
        return this.getIcons() != null && this.getIcons().length > 0;
    }

    public boolean hasServices() {
        return this.getServices() != null && this.getServices().length > 0;
    }

    public boolean hasEmbeddedDevices() {
        return this.getEmbeddedDevices() != null && this.getEmbeddedDevices().length > 0;
    }

    public D getParentDevice() {
        return this.parentDevice;
    }

    void setParentDevice(D parentDevice) {
        if (this.parentDevice != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.parentDevice = parentDevice;
    }

    public boolean isRoot() {
        return this.getParentDevice() == null;
    }

    public abstract S[] getServices();

    public abstract D[] getEmbeddedDevices();

    public abstract D getRoot();

    public abstract D findDevice(UDN var1);

    public D[] findEmbeddedDevices() {
        return this.toDeviceArray(this.findEmbeddedDevices(this));
    }

    public D[] findDevices(DeviceType deviceType) {
        return this.toDeviceArray(this.find(deviceType, this));
    }

    public D[] findDevices(ServiceType serviceType) {
        return this.toDeviceArray(this.find(serviceType, this));
    }

    public Icon[] findIcons() {
        Device[] embeddedDevices;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        if (this.hasIcons()) {
            icons.addAll(Arrays.asList(this.getIcons()));
        }
        for (Device embeddedDevice : embeddedDevices = this.findEmbeddedDevices()) {
            if (!embeddedDevice.hasIcons()) continue;
            icons.addAll(Arrays.asList(embeddedDevice.getIcons()));
        }
        return icons.toArray(new Icon[icons.size()]);
    }

    public S[] findServices() {
        return this.toServiceArray(this.findServices(null, null, this));
    }

    public S[] findServices(ServiceType serviceType) {
        return this.toServiceArray(this.findServices(serviceType, null, this));
    }

    protected D find(UDN udn, D current) {
        if (((Device)current).getIdentity() != null && ((DeviceIdentity)((Device)current).getIdentity()).getUdn() != null && ((DeviceIdentity)((Device)current).getIdentity()).getUdn().equals(udn)) {
            return current;
        }
        if (((Device)current).hasEmbeddedDevices()) {
            for (Device embeddedDevice : current.getEmbeddedDevices()) {
                Device match = this.find(udn, embeddedDevice);
                if (match == null) continue;
                return (D)match;
            }
        }
        return null;
    }

    protected Collection<D> findEmbeddedDevices(D current) {
        HashSet<Object> devices = new HashSet<Object>();
        if (!((Device)current).isRoot() && ((DeviceIdentity)((Device)current).getIdentity()).getUdn() != null) {
            devices.add(current);
        }
        if (((Device)current).hasEmbeddedDevices()) {
            for (Device embeddedDevice : current.getEmbeddedDevices()) {
                devices.addAll(this.findEmbeddedDevices(embeddedDevice));
            }
        }
        return devices;
    }

    protected Collection<D> find(DeviceType deviceType, D current) {
        HashSet<Object> devices = new HashSet<Object>();
        if (((Device)current).getType() != null && ((Device)current).getType().implementsVersion(deviceType)) {
            devices.add(current);
        }
        if (((Device)current).hasEmbeddedDevices()) {
            for (Device embeddedDevice : current.getEmbeddedDevices()) {
                devices.addAll(this.find(deviceType, embeddedDevice));
            }
        }
        return devices;
    }

    protected Collection<D> find(ServiceType serviceType, D current) {
        Collection<S> services = this.findServices(serviceType, null, current);
        HashSet devices = new HashSet();
        for (Service service : services) {
            devices.add(service.getDevice());
        }
        return devices;
    }

    protected Collection<S> findServices(ServiceType serviceType, ServiceId serviceId, D current) {
        Collection<D> embeddedDevices;
        HashSet<Service> services = new HashSet<Service>();
        if (((Device)current).hasServices()) {
            for (Service service : current.getServices()) {
                if (!this.isMatch(service, serviceType, serviceId)) continue;
                services.add(service);
            }
        }
        if ((embeddedDevices = this.findEmbeddedDevices(current)) != null) {
            for (Device embeddedDevice : embeddedDevices) {
                if (!embeddedDevice.hasServices()) continue;
                for (Service service : embeddedDevice.getServices()) {
                    if (!this.isMatch(service, serviceType, serviceId)) continue;
                    services.add(service);
                }
            }
        }
        return services;
    }

    public S findService(ServiceId serviceId) {
        Collection<S> services = this.findServices(null, serviceId, this);
        return (S)(services.size() == 1 ? (Service)services.iterator().next() : null);
    }

    public S findService(ServiceType serviceType) {
        Collection<S> services = this.findServices(serviceType, null, this);
        return (S)(services.size() > 0 ? (Service)services.iterator().next() : null);
    }

    public ServiceType[] findServiceTypes() {
        Collection<S> services = this.findServices(null, null, this);
        HashSet<ServiceType> col = new HashSet<ServiceType>();
        for (Service service : services) {
            col.add(service.getServiceType());
        }
        return col.toArray(new ServiceType[col.size()]);
    }

    private boolean isMatch(Service s, ServiceType serviceType, ServiceId serviceId) {
        boolean matchesType = serviceType == null || s.getServiceType().implementsVersion(serviceType);
        boolean matchesId = serviceId == null || s.getServiceId().equals(serviceId);
        return matchesType && matchesId;
    }

    public boolean isFullyHydrated() {
        Service[] services;
        for (Service service : services = this.findServices()) {
            if (!service.hasStateVariables()) continue;
            return true;
        }
        return false;
    }

    public String getDisplayString() {
        String cleanModelName = null;
        String cleanModelNumber = null;
        if (this.getDetails() != null && this.getDetails().getModelDetails() != null) {
            ModelDetails modelDetails = this.getDetails().getModelDetails();
            if (modelDetails.getModelName() != null) {
                String string = cleanModelName = modelDetails.getModelNumber() != null && modelDetails.getModelName().endsWith(modelDetails.getModelNumber()) ? modelDetails.getModelName().substring(0, modelDetails.getModelName().length() - modelDetails.getModelNumber().length()) : modelDetails.getModelName();
            }
            cleanModelNumber = cleanModelName != null ? (modelDetails.getModelNumber() != null && !cleanModelName.startsWith(modelDetails.getModelNumber()) ? modelDetails.getModelNumber() : "") : modelDetails.getModelNumber();
        }
        StringBuilder sb = new StringBuilder();
        if (this.getDetails() != null && this.getDetails().getManufacturerDetails() != null) {
            if (cleanModelName != null && this.getDetails().getManufacturerDetails().getManufacturer() != null) {
                String string = cleanModelName = cleanModelName.startsWith(this.getDetails().getManufacturerDetails().getManufacturer()) ? cleanModelName.substring(this.getDetails().getManufacturerDetails().getManufacturer().length()).trim() : cleanModelName.trim();
            }
            if (this.getDetails().getManufacturerDetails().getManufacturer() != null) {
                sb.append(this.getDetails().getManufacturerDetails().getManufacturer());
            }
        }
        sb.append(cleanModelName != null && cleanModelName.length() > 0 ? " " + cleanModelName : "");
        sb.append(cleanModelNumber != null && cleanModelNumber.length() > 0 ? " " + cleanModelNumber.trim() : "");
        return sb.toString();
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getType() != null) {
            errors.addAll(this.getVersion().validate());
            if (this.getIdentity() != null) {
                errors.addAll(((DeviceIdentity)this.getIdentity()).validate());
            }
            if (this.getDetails() != null) {
                errors.addAll(this.getDetails().validate());
            }
            if (this.hasServices()) {
                for (Service service : this.getServices()) {
                    if (service == null) continue;
                    errors.addAll(service.validate());
                }
            }
            if (this.hasEmbeddedDevices()) {
                for (Device embeddedDevice : this.getEmbeddedDevices()) {
                    if (embeddedDevice == null) continue;
                    errors.addAll(embeddedDevice.validate());
                }
            }
        }
        return errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return ((DeviceIdentity)this.identity).equals(device.identity);
    }

    public int hashCode() {
        return ((DeviceIdentity)this.identity).hashCode();
    }

    public abstract D newInstance(UDN var1, UDAVersion var2, DeviceType var3, DeviceDetails var4, Icon[] var5, S[] var6, List<D> var7) throws ValidationException;

    public abstract S newInstance(ServiceType var1, ServiceId var2, URI var3, URI var4, URI var5, Action<S>[] var6, StateVariable<S>[] var7) throws ValidationException;

    public abstract D[] toDeviceArray(Collection<D> var1);

    public abstract S[] newServiceArray(int var1);

    public abstract S[] toServiceArray(Collection<S> var1);

    public abstract Resource[] discoverResources(Namespace var1);

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Identity: " + ((DeviceIdentity)this.getIdentity()).toString() + ", Root: " + this.isRoot();
    }
}

