/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.async;

import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.ValidationError;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.message.IncomingDatagramMessage;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.discovery.IncomingSearchResponse;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.protocol.ReceivingAsync;
import org.fourthline.cling.protocol.RetrieveRemoteDescriptors;
import org.fourthline.cling.transport.RouterException;

public class ReceivingSearchResponse
extends ReceivingAsync<IncomingSearchResponse> {
    private static final Logger log = Logger.getLogger(ReceivingSearchResponse.class.getName());

    public ReceivingSearchResponse(UpnpService upnpService, IncomingDatagramMessage<UpnpResponse> inputMessage) {
        super(upnpService, new IncomingSearchResponse(inputMessage));
    }

    @Override
    protected void execute() throws RouterException {
        RemoteDevice rd;
        if (!((IncomingSearchResponse)this.getInputMessage()).isSearchResponseMessage()) {
            log.fine("Ignoring invalid search response message: " + this.getInputMessage());
            return;
        }
        UDN udn = ((IncomingSearchResponse)this.getInputMessage()).getRootDeviceUDN();
        if (udn == null) {
            log.fine("Ignoring search response message without UDN: " + this.getInputMessage());
            return;
        }
        RemoteDeviceIdentity rdIdentity = new RemoteDeviceIdentity((IncomingSearchResponse)this.getInputMessage());
        log.fine("Received device search response: " + rdIdentity);
        if (this.getUpnpService().getRegistry().update(rdIdentity)) {
            log.fine("Remote device was already known: " + udn);
            return;
        }
        try {
            rd = new RemoteDevice(rdIdentity);
        }
        catch (ValidationException ex) {
            log.warning("Validation errors of device during discovery: " + rdIdentity);
            for (ValidationError validationError : ex.getErrors()) {
                log.warning(validationError.toString());
            }
            return;
        }
        if (rdIdentity.getDescriptorURL() == null) {
            log.finer("Ignoring message without location URL header: " + this.getInputMessage());
            return;
        }
        if (rdIdentity.getMaxAgeSeconds() == null) {
            log.finer("Ignoring message without max-age header: " + this.getInputMessage());
            return;
        }
        this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(new RetrieveRemoteDescriptors(this.getUpnpService(), rd));
    }
}

