/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport;

import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.fourthline.cling.UpnpServiceConfiguration;
import org.fourthline.cling.model.NetworkAddress;
import org.fourthline.cling.model.message.IncomingDatagramMessage;
import org.fourthline.cling.model.message.OutgoingDatagramMessage;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.protocol.ProtocolCreationException;
import org.fourthline.cling.protocol.ProtocolFactory;
import org.fourthline.cling.protocol.ReceivingAsync;
import org.fourthline.cling.transport.DisableRouter;
import org.fourthline.cling.transport.EnableRouter;
import org.fourthline.cling.transport.Router;
import org.fourthline.cling.transport.RouterException;
import org.fourthline.cling.transport.spi.DatagramIO;
import org.fourthline.cling.transport.spi.InitializationException;
import org.fourthline.cling.transport.spi.MulticastReceiver;
import org.fourthline.cling.transport.spi.NetworkAddressFactory;
import org.fourthline.cling.transport.spi.NoNetworkException;
import org.fourthline.cling.transport.spi.StreamClient;
import org.fourthline.cling.transport.spi.StreamServer;
import org.fourthline.cling.transport.spi.UpnpStream;
import org.seamless.util.Exceptions;

@ApplicationScoped
public class RouterImpl
implements Router {
    private static Logger log = Logger.getLogger(Router.class.getName());
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected volatile boolean enabled;
    protected ReentrantReadWriteLock routerLock = new ReentrantReadWriteLock(true);
    protected Lock readLock = this.routerLock.readLock();
    protected Lock writeLock = this.routerLock.writeLock();
    protected NetworkAddressFactory networkAddressFactory;
    protected StreamClient streamClient;
    protected final Map<NetworkInterface, MulticastReceiver> multicastReceivers = new HashMap<NetworkInterface, MulticastReceiver>();
    protected final Map<InetAddress, DatagramIO> datagramIOs = new HashMap<InetAddress, DatagramIO>();
    protected final Map<InetAddress, StreamServer> streamServers = new HashMap<InetAddress, StreamServer>();

    protected RouterImpl() {
    }

    @Inject
    public RouterImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory) {
        log.info("Creating Router: " + this.getClass().getName());
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
    }

    public boolean enable(@Observes @Default EnableRouter event) throws RouterException {
        return this.enable();
    }

    public boolean disable(@Observes @Default DisableRouter event) throws RouterException {
        return this.disable();
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean enable() throws RouterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disable() throws RouterException {
        this.lock(this.writeLock);
        try {
            if (this.enabled) {
                log.fine("Disabling network services...");
                if (this.streamClient != null) {
                    log.fine("Stopping stream client connection management/pool");
                    this.streamClient.stop();
                    this.streamClient = null;
                }
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    log.fine("Stopping stream server on address: " + entry.getKey());
                    entry.getValue().stop();
                }
                this.streamServers.clear();
                for (Map.Entry<Object, Runnable> entry : this.multicastReceivers.entrySet()) {
                    log.fine("Stopping multicast receiver on interface: " + ((NetworkInterface)entry.getKey()).getDisplayName());
                    ((MulticastReceiver)entry.getValue()).stop();
                }
                this.multicastReceivers.clear();
                for (Map.Entry<Object, Runnable> entry : this.datagramIOs.entrySet()) {
                    log.fine("Stopping datagram I/O on address: " + entry.getKey());
                    ((DatagramIO)entry.getValue()).stop();
                }
                this.datagramIOs.clear();
                this.networkAddressFactory = null;
                this.enabled = false;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    @Override
    public void shutdown() throws RouterException {
        this.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void handleStartFailure(InitializationException ex) throws InitializationException {
        if (ex instanceof NoNetworkException) {
            log.info("Unable to initialize network router, no network found.");
        } else {
            log.severe("Unable to initialize network router: " + ex);
            log.severe("Cause: " + Exceptions.unwrap((Throwable)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled && this.streamServers.size() > 0) {
                StreamServer preferredServer;
                ArrayList<NetworkAddress> streamServerAddresses = new ArrayList<NetworkAddress>();
                if (preferredAddress != null && (preferredServer = this.streamServers.get(preferredAddress)) != null) {
                    streamServerAddresses.add(new NetworkAddress(preferredAddress, preferredServer.getPort(), this.networkAddressFactory.getHardwareAddress(preferredAddress)));
                    ArrayList<NetworkAddress> arrayList = streamServerAddresses;
                    return arrayList;
                }
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    byte[] hardwareAddress = this.networkAddressFactory.getHardwareAddress(entry.getKey());
                    streamServerAddresses.add(new NetworkAddress(entry.getKey(), entry.getValue().getPort(), hardwareAddress));
                }
                ArrayList<NetworkAddress> arrayList = streamServerAddresses;
                return arrayList;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public void received(IncomingDatagramMessage msg) {
        if (!this.enabled) {
            log.fine("Router disabled, ignoring incoming message: " + msg);
            return;
        }
        try {
            ReceivingAsync protocol = this.getProtocolFactory().createReceivingAsync(msg);
            if (protocol == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("No protocol, ignoring received message: " + msg);
                }
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Received asynchronous message: " + msg);
            }
            this.getConfiguration().getAsyncProtocolExecutor().execute(protocol);
        }
        catch (ProtocolCreationException ex) {
            log.warning("Handling received datagram failed - " + Exceptions.unwrap((Throwable)ex).toString());
        }
    }

    @Override
    public void received(UpnpStream stream) {
        if (!this.enabled) {
            log.fine("Router disabled, ignoring incoming: " + stream);
            return;
        }
        log.fine("Received synchronous stream: " + stream);
        this.getConfiguration().getSyncProtocolExecutorService().execute(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(OutgoingDatagramMessage msg) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                for (DatagramIO datagramIO : this.datagramIOs.values()) {
                    datagramIO.send(msg);
                }
            } else {
                log.fine("Router disabled, not sending datagram: " + msg);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamResponseMessage send(StreamRequestMessage msg) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                if (this.streamClient == null) {
                    log.fine("No StreamClient available, not sending: " + msg);
                    StreamResponseMessage streamResponseMessage = null;
                    return streamResponseMessage;
                }
                log.fine("Sending via TCP unicast stream: " + msg);
                try {
                    StreamResponseMessage streamResponseMessage = this.streamClient.sendRequest(msg);
                    return streamResponseMessage;
                }
                catch (InterruptedException ex) {
                    throw new RouterException("Sending stream request was interrupted", ex);
                }
            }
            log.fine("Router disabled, not sending stream request: " + msg);
            StreamResponseMessage streamResponseMessage = null;
            return streamResponseMessage;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(byte[] bytes) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                for (Map.Entry<InetAddress, DatagramIO> entry : this.datagramIOs.entrySet()) {
                    InetAddress broadcast = this.networkAddressFactory.getBroadcastAddress(entry.getKey());
                    if (broadcast == null) continue;
                    log.fine("Sending UDP datagram to broadcast address: " + broadcast.getHostAddress());
                    DatagramPacket packet = new DatagramPacket(bytes, bytes.length, broadcast, 9);
                    entry.getValue().send(packet);
                }
            } else {
                log.fine("Router disabled, not broadcasting bytes: " + bytes.length);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    protected void startInterfaceBasedTransports(Iterator<NetworkInterface> interfaces) throws InitializationException {
        while (interfaces.hasNext()) {
            NetworkInterface networkInterface = interfaces.next();
            MulticastReceiver multicastReceiver = this.getConfiguration().createMulticastReceiver(this.networkAddressFactory);
            if (multicastReceiver == null) {
                log.info("Configuration did not create a MulticastReceiver for: " + networkInterface);
                continue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Init multicast receiver on interface: " + networkInterface.getDisplayName());
            }
            multicastReceiver.init(networkInterface, this, this.networkAddressFactory, this.getConfiguration().getDatagramProcessor());
            this.multicastReceivers.put(networkInterface, multicastReceiver);
        }
        for (Map.Entry<NetworkInterface, MulticastReceiver> entry : this.multicastReceivers.entrySet()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting multicast receiver on interface: " + entry.getKey().getDisplayName());
            }
            this.getConfiguration().getMulticastReceiverExecutor().execute(entry.getValue());
        }
    }

    protected void startAddressBasedTransports(Iterator<InetAddress> addresses) throws InitializationException {
        while (addresses.hasNext()) {
            InetAddress address = addresses.next();
            StreamServer streamServer = this.getConfiguration().createStreamServer(this.networkAddressFactory);
            if (streamServer == null) {
                log.info("Configuration did not create a StreamServer for: " + address);
            } else {
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Init stream server on address: " + address);
                    }
                    streamServer.init(address, this);
                    this.streamServers.put(address, streamServer);
                }
                catch (InitializationException ex) {
                    Throwable cause = Exceptions.unwrap((Throwable)ex);
                    if (cause instanceof BindException) {
                        log.warning("Failed to init StreamServer: " + cause);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Initialization exception root cause", cause);
                        }
                        log.warning("Removing unusable address: " + address);
                        addresses.remove();
                        continue;
                    }
                    throw ex;
                }
            }
            DatagramIO datagramIO = this.getConfiguration().createDatagramIO(this.networkAddressFactory);
            if (datagramIO == null) {
                log.info("Configuration did not create a StreamServer for: " + address);
                continue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Init datagram I/O on address: " + address);
            }
            datagramIO.init(address, this, this.getConfiguration().getDatagramProcessor());
            this.datagramIOs.put(address, datagramIO);
        }
        for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting stream server on address: " + entry.getKey());
            }
            this.getConfiguration().getStreamServerExecutorService().execute(entry.getValue());
        }
        for (Map.Entry<InetAddress, Runnable> entry : this.datagramIOs.entrySet()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting datagram I/O on address: " + entry.getKey());
            }
            this.getConfiguration().getDatagramIOExecutor().execute(entry.getValue());
        }
    }

    protected void lock(Lock lock, int timeoutMilliseconds) throws RouterException {
        try {
            log.finest("Trying to obtain lock with timeout milliseconds '" + timeoutMilliseconds + "': " + lock.getClass().getSimpleName());
            if (!lock.tryLock(timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                throw new RouterException("Router wasn't available exclusively after waiting " + timeoutMilliseconds + "ms, lock failed: " + lock.getClass().getSimpleName());
            }
            log.finest("Acquired router lock: " + lock.getClass().getSimpleName());
        }
        catch (InterruptedException ex) {
            throw new RouterException("Interruption while waiting for exclusive access: " + lock.getClass().getSimpleName(), ex);
        }
    }

    protected void lock(Lock lock) throws RouterException {
        this.lock(lock, this.getLockTimeoutMillis());
    }

    protected void unlock(Lock lock) {
        log.finest("Releasing router lock: " + lock.getClass().getSimpleName());
        lock.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 6000;
    }
}

