/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fourthline.cling.model.message.Connection;
import org.fourthline.cling.transport.Router;
import org.fourthline.cling.transport.impl.AsyncServletStreamServerConfigurationImpl;
import org.fourthline.cling.transport.impl.AsyncServletUpnpStream;
import org.fourthline.cling.transport.spi.InitializationException;
import org.fourthline.cling.transport.spi.StreamServer;

public class AsyncServletStreamServerImpl
implements StreamServer<AsyncServletStreamServerConfigurationImpl> {
    private static final Logger log = Logger.getLogger(StreamServer.class.getName());
    protected final AsyncServletStreamServerConfigurationImpl configuration;
    protected int localPort;
    protected String hostAddress;
    private int mCounter = 0;

    public AsyncServletStreamServerImpl(AsyncServletStreamServerConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public AsyncServletStreamServerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void init(InetAddress bindAddress, Router router) throws InitializationException {
        try {
            log.info("Setting executor service on servlet container adapter");
            this.getConfiguration().getServletContainerAdapter().setExecutorService(router.getConfiguration().getStreamServerExecutorService());
            log.info("Adding connector: " + bindAddress + ":" + this.getConfiguration().getListenPort());
            this.hostAddress = bindAddress.getHostAddress();
            this.localPort = this.getConfiguration().getServletContainerAdapter().addConnector(this.hostAddress, this.getConfiguration().getListenPort());
            String contextPath = router.getConfiguration().getNamespace().getBasePath().getPath();
            this.getConfiguration().getServletContainerAdapter().registerServlet(contextPath, this.createServlet(router));
        }
        catch (Exception ex) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName() + ": " + ex.toString(), ex);
        }
    }

    @Override
    public synchronized int getPort() {
        return this.localPort;
    }

    @Override
    public synchronized void stop() {
        this.getConfiguration().getServletContainerAdapter().removeConnector(this.hostAddress, this.localPort);
    }

    @Override
    public void run() {
        this.getConfiguration().getServletContainerAdapter().startIfNotRunning();
    }

    protected Servlet createServlet(final Router router) {
        return new HttpServlet(){

            protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                final long startTime = System.currentTimeMillis();
                final int counter = AsyncServletStreamServerImpl.this.mCounter++;
                log.info(String.format("HttpServlet.service(): id: %3d, request URI: %s", counter, req.getRequestURI()));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Handling Servlet request asynchronously: " + req);
                }
                AsyncContext async = req.startAsync();
                async.setTimeout((long)(AsyncServletStreamServerImpl.this.getConfiguration().getAsyncTimeoutSeconds() * 1000));
                async.addListener(new AsyncListener(){

                    public void onTimeout(AsyncEvent arg0) throws IOException {
                        long duration = System.currentTimeMillis() - startTime;
                        log.warning(String.format("AsyncListener.onTimeout(): id: %3d, duration: %,4d, request: %s", counter, duration, arg0.getSuppliedRequest()));
                    }

                    public void onStartAsync(AsyncEvent arg0) throws IOException {
                        log.info(String.format("AsyncListener.onStartAsync(): id: %3d, request: %s", counter, arg0.getSuppliedRequest()));
                    }

                    public void onError(AsyncEvent arg0) throws IOException {
                        long duration = System.currentTimeMillis() - startTime;
                        log.warning(String.format("AsyncListener.onError(): id: %3d, duration: %,4d, response: %s", counter, duration, arg0.getSuppliedResponse()));
                    }

                    public void onComplete(AsyncEvent arg0) throws IOException {
                        long duration = System.currentTimeMillis() - startTime;
                        log.info(String.format("AsyncListener.onComplete(): id: %3d, duration: %,4d, response: %s", counter, duration, arg0.getSuppliedResponse()));
                    }
                });
                AsyncServletUpnpStream stream = new AsyncServletUpnpStream(router.getProtocolFactory(), async, req){

                    @Override
                    protected Connection createConnection() {
                        return new AsyncServletConnection(this.getRequest());
                    }
                };
                router.received(stream);
            }
        };
    }

    protected boolean isConnectionOpen(HttpServletRequest request) {
        return true;
    }

    protected class AsyncServletConnection
    implements Connection {
        protected HttpServletRequest request;

        public AsyncServletConnection(HttpServletRequest request) {
            this.request = request;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        @Override
        public boolean isOpen() {
            return AsyncServletStreamServerImpl.this.isConnectionOpen(this.getRequest());
        }

        @Override
        public InetAddress getRemoteAddress() {
            try {
                return InetAddress.getByName(this.getRequest().getRemoteAddr());
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public InetAddress getLocalAddress() {
            try {
                return InetAddress.getByName(this.getRequest().getLocalAddr());
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

