/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.sonoair;

import eu.mihosoft.vrl.base.ConfigurationFile;
import eu.mihosoft.vrl.base.IOUtil;
import eu.mihosoft.vrl.base.VRL;
import java.io.File;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;

public class ConfigController {
    public static final String KEY_DISCOVERY_TIMEOUT = "sonoair:discovery-timeout";
    public static final String KEY_ENABLE_DEBUG = "sonoair:enable-debug";
    public static final String KEY_DISABLE_EXPERIMENTAL_BUILD_WARNING_DIALOG = "sonoair:disable-experimental-build-warning-dialog";
    public static final String KEY_START_MINIMIZED = "sonoair:start-minimized";
    private final LongProperty discoveryTimeoutProperty = new SimpleLongProperty(10000L);
    private final BooleanProperty enableDebugProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty disableExperimentalWarningDialogProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty startMinimizedProperty = new SimpleBooleanProperty(false);
    private final File configFile = new File(VRL.getPropertyFolderManager().getConfigFolder(), "config.xml");
    private final ConfigurationFile config = IOUtil.newConfigurationFile(this.configFile);

    public ConfigController() {
        if (!this.config.load()) {
            System.err.println(">> WARNING: cannot load config file " + this.configFile);
        }
        this.initListeners();
    }

    private void initListeners() {
        this.getDiscoveryTimeoutProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_DISCOVERY_TIMEOUT, newV.toString());
            this.config.save();
        });
        this.getEnableDebugProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_ENABLE_DEBUG, newV.toString());
            this.config.save();
        });
        this.getDisableExperimentalWarningDialogProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_DISABLE_EXPERIMENTAL_BUILD_WARNING_DIALOG, newV.toString());
            this.config.save();
        });
        this.getStartMinimizedProperty().addListener((ov, oldV, newV) -> {
            this.config.setProperty(KEY_START_MINIMIZED, newV.toString());
            this.config.save();
        });
    }

    public void loadConfig() {
        String enableDebugOutputCbState = this.config.getProperty(KEY_ENABLE_DEBUG).orElse("" + this.getEnableDebugProperty().get());
        this.getEnableDebugProperty().set(Boolean.valueOf(enableDebugOutputCbState).booleanValue());
        String discoveryTimeoutTfState = this.config.getProperty(KEY_DISCOVERY_TIMEOUT).orElse("" + this.getDiscoveryTimeoutProperty().get());
        this.getDiscoveryTimeoutProperty().set(Long.valueOf(discoveryTimeoutTfState).longValue());
        String disableExperimentalWarningDialogState = this.config.getProperty(KEY_DISABLE_EXPERIMENTAL_BUILD_WARNING_DIALOG).orElse("" + this.getDisableExperimentalWarningDialogProperty().get());
        this.getDisableExperimentalWarningDialogProperty().set(Boolean.valueOf(disableExperimentalWarningDialogState).booleanValue());
        String startMinimizedState = this.config.getProperty(KEY_START_MINIMIZED).orElse("" + this.getStartMinimizedProperty().get());
        this.getStartMinimizedProperty().set(Boolean.valueOf(startMinimizedState).booleanValue());
    }

    public BooleanProperty getStartMinimizedProperty() {
        return this.startMinimizedProperty;
    }

    public BooleanProperty getDisableExperimentalWarningDialogProperty() {
        return this.disableExperimentalWarningDialogProperty;
    }

    public LongProperty getDiscoveryTimeoutProperty() {
        return this.discoveryTimeoutProperty;
    }

    public BooleanProperty getEnableDebugProperty() {
        return this.enableDebugProperty;
    }
}

