/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.ConfigurationFile;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConfigurationFileImpl
implements ConfigurationFile {
    private Map<String, String> properties = new HashMap<String, String>();
    private File file;

    public ConfigurationFileImpl(File f) {
        this.file = f;
    }

    @Override
    public boolean load() {
        boolean result = false;
        if (!this.file.isFile()) {
            return false;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex);
            try {
                in.close();
            }
            catch (Exception ex1) {
                Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        XMLDecoder d = new XMLDecoder(in);
        Object o = null;
        try {
            o = d.readObject();
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex);
            try {
                d.close();
            }
            catch (Exception ex1) {
                Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
        if (!(o instanceof Map)) {
            try {
                throw new IOException("Data format not recognized!");
            }
            catch (IOException ex) {
                Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex);
                try {
                    d.close();
                }
                catch (Exception ex1) {
                    Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
        } else {
            this.properties = (Map)o;
            result = true;
        }
        d.close();
        return result;
    }

    @Override
    public ConfigurationFile setProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public boolean save() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex);
            try {
                out.close();
            }
            catch (Exception ex1) {
                Logger.getLogger(ConfigurationFileImpl.class.getName()).log(Level.SEVERE, null, ex1);
            }
            return false;
        }
        XMLEncoder e = new XMLEncoder(out);
        e.writeObject(this.properties);
        e.flush();
        e.close();
        return true;
    }

    @Override
    public Optional<String> getProperty(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    @Override
    public Iterable<String> getKeys() {
        return this.properties.keySet();
    }

    @Override
    public Iterable<String> getValues() {
        return this.properties.values();
    }

    @Override
    public ConfigurationFile removeProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    @Override
    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }
}

