/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.VParamUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VJarUtil {
    private VJarUtil() {
        throw new AssertionError();
    }

    public static byte[] readCurrentJarEntry(JarInputStream jarInStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int len = 0;
        while ((len = jarInStream.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        return out.toByteArray();
    }

    public static List<String> getClassNamesFromStream(JarInputStream jarInStream) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        JarEntry entry = jarInStream.getNextJarEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean isInDirectory = name.lastIndexOf("/") > 0;
            boolean isClassFile = name.endsWith(".class");
            if (isInDirectory && isClassFile) {
                String className = VJarUtil.pathToClassName(name);
                result.add(className);
            }
            entry = jarInStream.getNextJarEntry();
        }
        jarInStream.close();
        return result;
    }

    public static List<String> getClassNamesFromJar(File f) throws IOException {
        return VJarUtil.getClassNamesFromStream(new JarInputStream(new FileInputStream(f)));
    }

    public static List<String> getEntryNamesFromStream(JarInputStream jarInStream) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        JarEntry entry = jarInStream.getNextJarEntry();
        while (entry != null) {
            String name = entry.getName();
            result.add(name);
            entry = jarInStream.getNextJarEntry();
        }
        jarInStream.close();
        return result;
    }

    public static String pathToClassName(String path) {
        return path.substring(0, path.length() - 6).replace("/", ".");
    }

    public static Collection<Class<?>> loadClasses(File f) {
        return VJarUtil.loadClasses(f, null);
    }

    public static Collection<Class<?>> loadClasses(File f, ClassLoader loader) {
        List<String> classNames = null;
        try {
            classNames = VJarUtil.getClassNamesFromStream(new JarInputStream(new FileInputStream(f)));
            if (loader == null) {
                loader = new URLClassLoader(new URL[]{f.toURI().toURL()});
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VJarUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList classes = new ArrayList();
        for (String n : classNames) {
            try {
                classes.add(loader.loadClass(n));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            }
            catch (Throwable throwable) {}
        }
        return classes;
    }

    public static boolean containsEntry(File in, String entryName) {
        if (!in.isFile()) {
            throw new IllegalArgumentException("The file \"" + in + "\" is a directory or does not exit!");
        }
        if (!in.getAbsolutePath().toLowerCase().endsWith(".jar")) {
            return false;
        }
        try {
            JarFile jar = new JarFile(in);
            boolean result = jar.getEntry(entryName) != null;
            jar.close();
            return result;
        }
        catch (IOException ex) {
            Logger.getLogger(VJarUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static void extractJarFile(File in, File out) throws IOException {
        if (!in.isFile()) {
            throw new IllegalArgumentException("The file \"" + in + "\" is a directory or does not exit!");
        }
        if (!out.isDirectory()) {
            throw new IllegalArgumentException("The file \"" + in + "\" is no directory or does not exit!");
        }
        JarFile jar = new JarFile(in);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            int count;
            JarEntry file = entries.nextElement();
            File f = new File(out + File.separator + file.getName());
            if (file.isDirectory()) {
                f.mkdir();
                continue;
            }
            BufferedInputStream is = new BufferedInputStream(jar.getInputStream(file));
            FileOutputStream fos = new FileOutputStream(f);
            byte[] buffer = new byte[1024];
            while ((count = is.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            is.close();
        }
    }

    public static File getClassLocation(Class<?> cls) {
        VParamUtil.throwIfNull(cls);
        String className = cls.getName();
        ClassLoader cl = cls.getClassLoader();
        URL url = cl.getResource(className.replace(".", "/") + ".class");
        String urlString = url.toString().replace("jar:", "");
        if (!urlString.startsWith("file:")) {
            throw new IllegalArgumentException("The specified class\"" + cls.getName() + "\" has not been loaded from a locationon the local filesystem.");
        }
        try {
            urlString = URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(VJarUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        urlString = urlString.replace("file:", "");
        int location = urlString.indexOf(".jar!");
        if (location > 0) {
            urlString = urlString.substring(0, location) + ".jar";
        }
        return new File(urlString);
    }

    public static void writeManifest(File location) throws IOException {
        VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FOLDER, (Object)location, new Object[0]);
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("Manifest-Version: 1.0\n");
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(sbuf.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(VJarUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        File meta_inf = new File(location.getAbsolutePath() + "/META-INF");
        meta_inf.mkdir();
        Manifest manifest = new Manifest(is);
        manifest.write(new FileOutputStream(new File(meta_inf.getAbsolutePath() + "/MANIFEST.MF")));
    }
}

