/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.IOUtil;
import eu.mihosoft.vrl.base.VParamUtil;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VSysUtil {
    public static final String OS_LINUX = "Linux";
    public static final String OS_MAC = "Mac OS X";
    public static final String OS_WINDOWS = "Windows";
    public static final String OS_OTHER = "Other";
    public static final String[] SUPPORTED_OPERATING_SYSTEMS = new String[]{"Linux", "Mac OS X", "Windows"};
    public static final String[] SUPPORTED_ARCHITECTURES = new String[]{"x86", "i386", "i686", "x86_64", "amd64"};

    private VSysUtil() {
        throw new AssertionError();
    }

    public static String getArchName() {
        String osArch = System.getProperty("os.arch");
        if (!VSysUtil.isArchSupported()) {
            return "generic";
        }
        String archName = "x86";
        if (osArch.contains("64")) {
            archName = "x64";
        }
        return archName;
    }

    public static String getOSName() {
        String osName = System.getProperty("os.name");
        if (osName.contains(OS_LINUX)) {
            return "linux";
        }
        if (osName.contains(OS_MAC)) {
            return "osx";
        }
        if (osName.contains(OS_WINDOWS)) {
            return "windows";
        }
        return "generic";
    }

    public static String getPlatformSpecificPath() {
        String result = "";
        String osName = System.getProperty("os.name");
        String archFolder = VSysUtil.getArchName() + "/";
        result = osName.contains(OS_LINUX) ? result + "linux/" + archFolder : (osName.contains(OS_MAC) ? result + "osx/" : (osName.contains(OS_WINDOWS) ? result + "windows/" + archFolder : result + "generic/"));
        return result;
    }

    public static boolean isWindows() {
        return VSysUtil.getOS().equals(OS_WINDOWS);
    }

    public static boolean isMacOSX() {
        return VSysUtil.getOS().equals(OS_MAC);
    }

    public static boolean isLinux() {
        return VSysUtil.getOS().equals(OS_LINUX);
    }

    public static String getPlatformSpecificLibraryEnding(String os) {
        VParamUtil.throwIfNull(os);
        if (os.equals(OS_MAC)) {
            return "dylib";
        }
        if (os.equals(OS_LINUX)) {
            return "so";
        }
        if (os.equals(OS_WINDOWS)) {
            return "dll";
        }
        return "so";
    }

    public static String getPlatformSpecificLibraryEnding() {
        return VSysUtil.getPlatformSpecificLibraryEnding(VSysUtil.getOS());
    }

    public static String getPlatformInfo() {
        String arch = VSysUtil.getArchName();
        return System.getProperty("os.name") + " (" + arch + ")";
    }

    public static boolean loadNativeLibrariesInFolder(File folder, boolean recursive) {
        VParamUtil.throwIfNotValid(VParamUtil.VALIDATOR_EXISTING_FOLDER, (Object)folder, new Object[0]);
        final String dylibEnding = "." + VSysUtil.getPlatformSpecificLibraryEnding();
        ArrayList<File> dynamicLibraries = new ArrayList<File>();
        if (recursive) {
            dynamicLibraries.addAll(IOUtil.listFiles(folder, new String[]{dylibEnding}));
        } else {
            File[] libFiles = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(dylibEnding);
                }
            });
            dynamicLibraries.addAll(Arrays.asList(libFiles));
        }
        System.out.println(">> loading native libraries:");
        ArrayList<String> loadedLibraries = new ArrayList<String>();
        ArrayList<String> errorLibraries = new ArrayList<String>();
        int lastSize = -1;
        while (loadedLibraries.size() > lastSize) {
            lastSize = loadedLibraries.size();
            for (File f : dynamicLibraries) {
                String libName = f.getAbsolutePath();
                if (loadedLibraries.contains(libName)) continue;
                try {
                    System.load(libName);
                    loadedLibraries.add(libName);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                catch (UnsatisfiedLinkError ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        boolean errors = loadedLibraries.size() != dynamicLibraries.size();
        for (File f : dynamicLibraries) {
            if (loadedLibraries.contains(f.getAbsolutePath())) continue;
            errorLibraries.add(f.getName());
        }
        System.out.println(" --> done.");
        if (errors) {
            System.err.println(">> Not Loaded:");
            for (String loadedLib : errorLibraries) {
                System.err.println("--> " + loadedLib);
            }
        }
        return !errors;
    }

    public static boolean loadNativeLibrariesInFolder(File folder) {
        return VSysUtil.loadNativeLibrariesInFolder(folder, true);
    }

    public static String getSystemBinaryPath() {
        return "bin/" + VSysUtil.getPlatformSpecificPath();
    }

    public static String getCustomBinaryPath() {
        return "custom-bin/" + VSysUtil.getPlatformSpecificPath();
    }

    public static boolean isOsSupported() {
        boolean result = false;
        String osName = System.getProperty("os.name");
        for (String s : SUPPORTED_OPERATING_SYSTEMS) {
            if (!osName.contains(s)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getOS() {
        String result = OS_OTHER;
        String osName = System.getProperty("os.name");
        for (String s : SUPPORTED_OPERATING_SYSTEMS) {
            if (!osName.contains(s)) continue;
            result = s;
            break;
        }
        return result;
    }

    public static boolean isArchSupported() {
        boolean result = false;
        String osArch = System.getProperty("os.arch");
        for (String s : SUPPORTED_ARCHITECTURES) {
            if (!s.equals(osArch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void copyToClipboard(String s) {
        TextTransfer textTransfer = new TextTransfer();
        textTransfer.setClipboardContents(s);
    }

    public static String copyFromClipboard() {
        TextTransfer textTransfer = new TextTransfer();
        return textTransfer.getClipboardContents();
    }

    public static void addNativeLibraryPath(String path) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!path.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = path;
            field.set(null, tmp);
            System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + path);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    public static boolean isDesktopSupported() {
        return Desktop.isDesktopSupported();
    }

    public static boolean isBrowserActionSupported() {
        Desktop desktop = Desktop.getDesktop();
        return desktop.isSupported(Desktop.Action.BROWSE);
    }

    public static boolean openURI(URI uri) {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(uri);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(VSysUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean isProgramInstalledOnUnix(String program) {
        if (!VSysUtil.isWindows()) {
            try {
                String msg = "";
                Process p = new ProcessBuilder("which", program).start();
                p.waitFor();
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    msg = msg + line + "\n";
                }
                return msg.isEmpty();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(VSysUtil.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IOException ex) {
                return false;
            }
        }
        throw new IllegalStateException("This command does not support Windows OS!");
    }

    public static boolean openFileInDefaultFileBrowser(File f) {
        try {
            if (VSysUtil.isWindows()) {
                Process process = new ProcessBuilder("explorer.exe", "/select," + f.getAbsolutePath()).start();
            } else if (VSysUtil.isMacOSX()) {
                Process process = new ProcessBuilder("open", "-R", f.getAbsolutePath()).start();
            } else if (VSysUtil.isLinux()) {
                if (VSysUtil.isKDERunning()) {
                    Process process = new ProcessBuilder("dolphin", "--select", f.getAbsolutePath()).start();
                } else if (VSysUtil.isProgramInstalledOnUnix("nautilus")) {
                    Process process = new ProcessBuilder("nautilus", "--browser", f.getAbsolutePath()).start();
                } else if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(f);
                }
            } else if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(f);
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean isKDERunning() {
        if (VSysUtil.isWindows()) {
            return false;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            String msg = "";
            Process pr = rt.exec("sh -c ps aux");
            pr.waitFor();
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                msg = msg + line + "\n";
            }
            return msg.contains("kdeinit4");
        }
        catch (InterruptedException ex) {
            Logger.getLogger(VSysUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(VSysUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean isGnomeOrUnityRunning() {
        if (VSysUtil.isWindows()) {
            return false;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            String msg = "";
            Process pr = rt.exec("sh -c ps aux");
            pr.waitFor();
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                msg = msg + line + "\n";
            }
            return msg.contains("gnome-session");
        }
        catch (InterruptedException ex) {
            Logger.getLogger(VSysUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean runWithAdminPrivileges(String cmd) {
        throw new UnsupportedOperationException("Unfortunately, this is feature not implemented yet!");
    }

    private static class TextTransfer
    implements ClipboardOwner {
        private TextTransfer() {
        }

        @Override
        public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
        }

        public void setClipboardContents(String aString) {
            StringSelection stringSelection = new StringSelection(aString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, this);
        }

        public String getClipboardContents() {
            boolean hasTransferableText;
            String result = "";
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (hasTransferableText) {
                try {
                    result = (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    Logger.getLogger(VSysUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(VSysUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return result;
        }
    }
}

