/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.AbstractVersionInfo;
import java.util.ArrayList;

public final class VersionInfo
implements Comparable,
AbstractVersionInfo {
    private String version;
    private String description;
    public static final String UNDEFINED = "x";

    public VersionInfo() {
    }

    public VersionInfo(String version) {
        this.setVersion(version);
    }

    public VersionInfo(String version, String description) {
        this.setVersion(version);
        this.description = description;
    }

    @Override
    public boolean isVersionValid() {
        boolean result = true;
        try {
            this.parseVersionString(this.version);
        }
        catch (IllegalArgumentException ex) {
            result = false;
        }
        return result;
    }

    private ArrayList<Integer> parseVersionString(String s) throws IllegalArgumentException {
        String[] numbers;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String n : numbers = s.split("\\.")) {
            if (!n.matches("\\d+")) {
                if (n.equals(UNDEFINED)) break;
                throw new IllegalArgumentException("Version string has wrong format: \"" + s + "\"");
            }
            result.add(new Integer(n));
        }
        return result;
    }

    private ArrayList<Integer> getVersionArray() {
        return this.parseVersionString(this.version);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        try {
            this.parseVersionString(version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.version = version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int compareTo(Object o) {
        int result = 0;
        if (o instanceof AbstractVersionInfo) {
            AbstractVersionInfo aV = (AbstractVersionInfo)o;
            VersionInfo comp = new VersionInfo(aV.getVersion(), aV.getDescription());
            ArrayList<Integer> compVersion = comp.getVersionArray();
            ArrayList<Integer> ourVersion = this.getVersionArray();
            int size = Math.min(ourVersion.size(), compVersion.size());
            for (int i = 0; i < size && ourVersion.get(i) != null && compVersion.get(i) != null; ++i) {
                if (ourVersion.get(i) < compVersion.get(i)) {
                    result = -1;
                } else {
                    if (ourVersion.get(i) == compVersion.get(i) || ourVersion.get(i) <= compVersion.get(i)) continue;
                    result = 1;
                }
                break;
            }
        } else {
            throw new IllegalArgumentException("Argument is no VersionInfo object!");
        }
        return result;
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public String toString() {
        return this.getVersion();
    }
}

