/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.upnp.sonos;

import eu.mihosoft.upnp.sonos.ZonePlayer;
import eu.mihosoft.upnp.sonos.ZonePlayers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZoneGroup {
    private final List<String> devices = new ArrayList<String>();
    private final String coordinator;
    private String name;
    private final String id;
    private final ZonePlayers zonePlayers;

    ZoneGroup(ZonePlayers zPlayers, org.tensin.sonos.model.ZoneGroup g) {
        this.zonePlayers = zPlayers;
        this.devices.addAll(g.getMembers());
        this.coordinator = g.getCoordinator();
        this.id = g.getId();
        this.name = null;
    }

    public List<String> getDevices() {
        return this.devices;
    }

    public ZonePlayer getCoordinator() {
        return this.zonePlayers.getDiscoveredPlayers().stream().filter(p -> Objects.equals(p.getZoneId(), this.getCoordinatorId())).findFirst().orElse(null);
    }

    private String getCoordinatorId() {
        return this.coordinator;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.getCoordinator().getZoneName();
            }
            catch (Exception ex) {
                Logger.getLogger(ZoneGroup.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.name;
    }

    public boolean isGroup() {
        return this.getDevices().size() > 1;
    }

    public String toString() {
        String memberString = String.join((CharSequence)", ", this.devices);
        return "[Group: " + this.getId() + ", coordinator: " + this.getCoordinatorId() + ", [members: " + memberString + "]]";
    }
}

