/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.upnp.sonos;

import eu.mihosoft.upnp.sonos.ZoneGroup;
import eu.mihosoft.upnp.sonos.ZoneGroupService;
import eu.mihosoft.upnp.sonos.ZonePlayers;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.MediaRendererDevice;
import org.tensin.sonos.model.Entry;
import org.tensin.sonos.model.PlayMode;
import org.tensin.sonos.model.PositionInfo;

public class ZonePlayer {
    private static final Logger LOG = LoggerFactory.getLogger(ZonePlayer.class);
    private final org.tensin.sonos.control.ZonePlayer wrappedZonePlayer;
    private final ZoneGroupService groupService;
    private List<ZoneGroup> groups;
    private final String zoneName;
    private final String zoneId;
    private final MediaRendererDevice mediaRenderer;
    private final RemoteDevice remoteDevice;
    private final UpnpService upnpService;

    public ZonePlayer(RemoteDevice remoteDevice, UpnpService upnpService) {
        this.remoteDevice = remoteDevice;
        this.upnpService = upnpService;
        this.wrappedZonePlayer = new org.tensin.sonos.control.ZonePlayer(upnpService, remoteDevice);
        this.zoneName = this.wrappedZonePlayer.getDevicePropertiesService().getZoneAttributes().getName();
        this.zoneId = ((RemoteDeviceIdentity)remoteDevice.getIdentity()).getUdn().getIdentifierString();
        this.mediaRenderer = this.wrappedZonePlayer.getMediaRendererDevice();
        this.groupService = new ZoneGroupService(upnpService, AbstractService.findService(remoteDevice, "urn:schemas-upnp-org:service:ZoneGroupTopology:1"));
    }

    public void play() {
        this.mediaRenderer.getRenderingControlService().setMute(false);
        this.mediaRenderer.getAvTransportService().setPlayMode(PlayMode.NORMAL);
        this.mediaRenderer.getAvTransportService().play();
    }

    public void stop() {
        this.mediaRenderer.getAvTransportService().stop();
    }

    public void pause() {
        this.mediaRenderer.getAvTransportService().pause();
    }

    public boolean isMuted() {
        return this.getNewMediaRenderer().getRenderingControlService().getMute();
    }

    public void toggleMute() {
        this.mediaRenderer.getRenderingControlService().setMute(!this.isMuted());
    }

    public int getVolume() {
        return this.getNewMediaRenderer().getRenderingControlService().getVolume();
    }

    public String getCurrentTrackName() {
        PositionInfo mediaInfo = this.getNewMediaRenderer().getAvTransportService().getPositionInfo();
        String trackName = mediaInfo.getTrackMetaData().getCreator() + " - " + mediaInfo.getTrackMetaData().getTitle();
        return trackName;
    }

    public List<String> getQueue() {
        try {
            ArrayList<String> queue = new ArrayList<String>();
            List<Entry> entries = this.wrappedZonePlayer.getMediaServerDevice().getContentDirectoryService().getQueue(0, Integer.MAX_VALUE);
            for (Entry entry : entries) {
                queue.add(entry.getCreator() + " - " + entry.getTitle());
            }
            return queue;
        }
        catch (SonosException e) {
            LOG.error("Error while fetching queue: ", e);
            return null;
        }
    }

    public void playStartOfQueue() {
        try {
            this.wrappedZonePlayer.playQueueEntry(0);
        }
        catch (SonosException e) {
            LOG.error("Error while moving to start of queue: ", e);
        }
    }

    public void setVolume(int volume) {
        this.mediaRenderer.getRenderingControlService().setVolume(volume);
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void nextTrack() {
        this.mediaRenderer.getAvTransportService().next();
    }

    public void previousTrack() {
        this.mediaRenderer.getAvTransportService().previous();
    }

    private MediaRendererDevice getNewMediaRenderer() {
        return new org.tensin.sonos.control.ZonePlayer(this.upnpService, this.remoteDevice).getMediaRendererDevice();
    }

    public void setLedEnabled(boolean status) {
        this.wrappedZonePlayer.getDevicePropertiesService().setLEDState(status);
    }

    public boolean isLedEnabled() {
        return this.wrappedZonePlayer.getDevicePropertiesService().getLEDState();
    }

    public String getIPv4Adress() {
        return this.wrappedZonePlayer.getIP().toString().replace("/", "");
    }

    List<ZoneGroup> getZoneGroups(ZonePlayers zPlayers) {
        if (this.groups == null) {
            this.groups = this.groupService.getZoneGroupState().getGroups().stream().map(zG -> new ZoneGroup(zPlayers, (org.tensin.sonos.model.ZoneGroup)zG)).distinct().collect(Collectors.toList());
        }
        return this.groups;
    }
}

