/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.transport.spi.InitializationException;
import org.fourthline.cling.transport.spi.NetworkAddressFactory;
import org.fourthline.cling.transport.spi.NoNetworkException;
import org.seamless.util.Iterators;

public class NetworkAddressFactoryImpl
implements NetworkAddressFactory {
    public static final int DEFAULT_TCP_HTTP_LISTEN_PORT = 0;
    private static Logger log = Logger.getLogger(NetworkAddressFactoryImpl.class.getName());
    protected final Set<String> useInterfaces = new HashSet<String>();
    protected final Set<String> useAddresses = new HashSet<String>();
    protected final List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    protected final List<InetAddress> bindAddresses = new ArrayList<InetAddress>();
    protected int streamListenPort;

    public NetworkAddressFactoryImpl() throws InitializationException {
        this(0);
    }

    public NetworkAddressFactoryImpl(int streamListenPort) throws InitializationException {
        String useAddressesString;
        System.setProperty("java.net.preferIPv4Stack", "true");
        String useInterfacesString = System.getProperty("org.fourthline.cling.network.useInterfaces");
        if (useInterfacesString != null) {
            String[] userInterfacesStrings = useInterfacesString.split(",");
            this.useInterfaces.addAll(Arrays.asList(userInterfacesStrings));
        }
        if ((useAddressesString = System.getProperty("org.fourthline.cling.network.useAddresses")) != null) {
            String[] useAddressesStrings = useAddressesString.split(",");
            this.useAddresses.addAll(Arrays.asList(useAddressesStrings));
        }
        this.discoverNetworkInterfaces();
        this.discoverBindAddresses();
        if (this.networkInterfaces.size() == 0 || this.bindAddresses.size() == 0) {
            log.warning("No usable network interface or addresses found");
            if (this.requiresNetworkInterface()) {
                throw new NoNetworkException("Could not discover any usable network interfaces and/or addresses");
            }
        }
        this.streamListenPort = streamListenPort;
    }

    protected boolean requiresNetworkInterface() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logInterfaceInformation() {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            if (this.networkInterfaces.isEmpty()) {
                log.info("No network interface to display!");
                return;
            }
            for (NetworkInterface networkInterface : this.networkInterfaces) {
                try {
                    this.logInterfaceInformation(networkInterface);
                }
                catch (SocketException ex) {
                    log.log(Level.WARNING, "Exception while logging network interface information", ex);
                }
            }
        }
    }

    @Override
    public InetAddress getMulticastGroup() {
        try {
            return InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getMulticastPort() {
        return 1900;
    }

    @Override
    public int getStreamListenPort() {
        return this.streamListenPort;
    }

    @Override
    public Iterator<NetworkInterface> getNetworkInterfaces() {
        return new Iterators.Synchronized<NetworkInterface>(this.networkInterfaces){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<NetworkInterface> list = NetworkAddressFactoryImpl.this.networkInterfaces;
                synchronized (list) {
                    NetworkAddressFactoryImpl.this.networkInterfaces.remove(index);
                }
            }
        };
    }

    @Override
    public Iterator<InetAddress> getBindAddresses() {
        return new Iterators.Synchronized<InetAddress>(this.bindAddresses){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<InetAddress> list = NetworkAddressFactoryImpl.this.bindAddresses;
                synchronized (list) {
                    NetworkAddressFactoryImpl.this.bindAddresses.remove(index);
                }
            }
        };
    }

    @Override
    public boolean hasUsableNetwork() {
        return this.networkInterfaces.size() > 0 && this.bindAddresses.size() > 0;
    }

    @Override
    public byte[] getHardwareAddress(InetAddress inetAddress) {
        try {
            NetworkInterface iface = NetworkInterface.getByInetAddress(inetAddress);
            return iface != null ? iface.getHardwareAddress() : null;
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Cannot get hardware address for: " + inetAddress, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getBroadcastAddress(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress interfaceAddress : this.getInterfaceAddresses(iface)) {
                    if (interfaceAddress == null || !interfaceAddress.getAddress().equals(inetAddress)) continue;
                    return interfaceAddress.getBroadcast();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short getAddressNetworkPrefixLength(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress interfaceAddress : this.getInterfaceAddresses(iface)) {
                    if (interfaceAddress == null || !interfaceAddress.getAddress().equals(inetAddress)) continue;
                    short prefix = interfaceAddress.getNetworkPrefixLength();
                    if (prefix > 0 && prefix < 32) {
                        return prefix;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public InetAddress getLocalAddress(NetworkInterface networkInterface, boolean isIPv6, InetAddress remoteAddress) {
        InetAddress localIPInSubnet = this.getBindAddressInSubnetOf(remoteAddress);
        if (localIPInSubnet != null) {
            return localIPInSubnet;
        }
        log.finer("Could not find local bind address in same subnet as: " + remoteAddress.getHostAddress());
        for (InetAddress interfaceAddress : this.getInetAddresses(networkInterface)) {
            if (isIPv6 && interfaceAddress instanceof Inet6Address) {
                return interfaceAddress;
            }
            if (isIPv6 || !(interfaceAddress instanceof Inet4Address)) continue;
            return interfaceAddress;
        }
        throw new IllegalStateException("Can't find any IPv4 or IPv6 address on interface: " + networkInterface.getDisplayName());
    }

    protected List<InterfaceAddress> getInterfaceAddresses(NetworkInterface networkInterface) {
        return networkInterface.getInterfaceAddresses();
    }

    protected List<InetAddress> getInetAddresses(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InetAddress getBindAddressInSubnetOf(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress ifaceAddress : this.getInterfaceAddresses(iface)) {
                    List<InetAddress> list2 = this.bindAddresses;
                    synchronized (list2) {
                        if (ifaceAddress == null || !this.bindAddresses.contains(ifaceAddress.getAddress())) {
                            continue;
                        }
                    }
                    if (!this.isInSubnet(inetAddress.getAddress(), ifaceAddress.getAddress().getAddress(), ifaceAddress.getNetworkPrefixLength())) continue;
                    return ifaceAddress.getAddress();
                }
            }
        }
        return null;
    }

    protected boolean isInSubnet(byte[] ip, byte[] network, short prefix) {
        int i;
        if (ip.length != network.length) {
            return false;
        }
        if (prefix / 8 > ip.length) {
            return false;
        }
        for (i = 0; prefix >= 8 && i < ip.length; ++i, prefix = (short)(prefix - 8)) {
            if (ip[i] == network[i]) continue;
            return false;
        }
        if (i == ip.length) {
            return true;
        }
        byte mask = (byte)(~((1 << 8 - prefix) - 1));
        return (ip[i] & mask) == (network[i] & mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverNetworkInterfaces() throws InitializationException {
        try {
            Enumeration<NetworkInterface> interfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(interfaceEnumeration)) {
                log.finer("Analyzing network interface: " + iface.getDisplayName());
                if (this.isUsableNetworkInterface(iface)) {
                    log.fine("Discovered usable network interface: " + iface.getDisplayName());
                    List<NetworkInterface> list = this.networkInterfaces;
                    synchronized (list) {
                        this.networkInterfaces.add(iface);
                        continue;
                    }
                }
                log.finer("Ignoring non-usable network interface: " + iface.getDisplayName());
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not not analyze local network interfaces: " + ex, ex);
        }
    }

    protected boolean isUsableNetworkInterface(NetworkInterface iface) throws Exception {
        if (!iface.isUp()) {
            log.finer("Skipping network interface (down): " + iface.getDisplayName());
            return false;
        }
        if (this.getInetAddresses(iface).size() == 0) {
            log.finer("Skipping network interface without bound IP addresses: " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ROOT).startsWith("vmnet") || iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ROOT).contains("vmnet")) {
            log.finer("Skipping network interface (VMWare): " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ROOT).startsWith("vnic")) {
            log.finer("Skipping network interface (Parallels): " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ROOT).contains("virtual")) {
            log.finer("Skipping network interface (named '*virtual*'): " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ROOT).startsWith("ppp")) {
            log.finer("Skipping network interface (PPP): " + iface.getDisplayName());
            return false;
        }
        if (iface.isLoopback()) {
            log.finer("Skipping network interface (ignoring loopback): " + iface.getDisplayName());
            return false;
        }
        if (this.useInterfaces.size() > 0 && !this.useInterfaces.contains(iface.getName())) {
            log.finer("Skipping unwanted network interface (-Dorg.fourthline.cling.network.useInterfaces): " + iface.getName());
            return false;
        }
        if (!iface.supportsMulticast()) {
            log.warning("Network interface may not be multicast capable: " + iface.getDisplayName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverBindAddresses() throws InitializationException {
        try {
            List<NetworkInterface> list = this.networkInterfaces;
            synchronized (list) {
                Iterator<NetworkInterface> it = this.networkInterfaces.iterator();
                while (it.hasNext()) {
                    NetworkInterface networkInterface = it.next();
                    log.finer("Discovering addresses of interface: " + networkInterface.getDisplayName());
                    int usableAddresses = 0;
                    for (InetAddress inetAddress : this.getInetAddresses(networkInterface)) {
                        if (inetAddress == null) {
                            log.warning("Network has a null address: " + networkInterface.getDisplayName());
                            continue;
                        }
                        if (this.isUsableAddress(networkInterface, inetAddress)) {
                            log.fine("Discovered usable network interface address: " + inetAddress.getHostAddress());
                            ++usableAddresses;
                            List<InetAddress> list2 = this.bindAddresses;
                            synchronized (list2) {
                                this.bindAddresses.add(inetAddress);
                                continue;
                            }
                        }
                        log.finer("Ignoring non-usable network interface address: " + inetAddress.getHostAddress());
                    }
                    if (usableAddresses != 0) continue;
                    log.finer("Network interface has no usable addresses, removing: " + networkInterface.getDisplayName());
                    it.remove();
                }
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not not analyze local network interfaces: " + ex, ex);
        }
    }

    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            log.finer("Skipping unsupported non-IPv4 address: " + address);
            return false;
        }
        if (address.isLoopbackAddress()) {
            log.finer("Skipping loopback address: " + address);
            return false;
        }
        if (this.useAddresses.size() > 0 && !this.useAddresses.contains(address.getHostAddress())) {
            log.finer("Skipping unwanted address: " + address);
            return false;
        }
        return true;
    }

    protected void logInterfaceInformation(NetworkInterface networkInterface) throws SocketException {
        log.info("---------------------------------------------------------------------------------");
        log.info(String.format("Interface display name: %s", networkInterface.getDisplayName()));
        if (networkInterface.getParent() != null) {
            log.info(String.format("Parent Info: %s", networkInterface.getParent()));
        }
        log.info(String.format("Name: %s", networkInterface.getName()));
        Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            log.info(String.format("InetAddress: %s", inetAddress));
        }
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            if (interfaceAddress == null) {
                log.warning("Skipping null InterfaceAddress!");
                continue;
            }
            log.info(" Interface Address");
            log.info("  Address: " + interfaceAddress.getAddress());
            log.info("  Broadcast: " + interfaceAddress.getBroadcast());
            log.info("  Prefix length: " + interfaceAddress.getNetworkPrefixLength());
        }
        Enumeration<NetworkInterface> subIfs = networkInterface.getSubInterfaces();
        for (NetworkInterface subIf : Collections.list(subIfs)) {
            if (subIf == null) {
                log.warning("Skipping null NetworkInterface sub-interface");
                continue;
            }
            log.info(String.format("\tSub Interface Display name: %s", subIf.getDisplayName()));
            log.info(String.format("\tSub Interface Name: %s", subIf.getName()));
        }
        log.info(String.format("Up? %s", networkInterface.isUp()));
        log.info(String.format("Loopback? %s", networkInterface.isLoopback()));
        log.info(String.format("PointToPoint? %s", networkInterface.isPointToPoint()));
        log.info(String.format("Supports multicast? %s", networkInterface.supportsMulticast()));
        log.info(String.format("Virtual? %s", networkInterface.isVirtual()));
        log.info(String.format("Hardware address: %s", Arrays.toString(networkInterface.getHardwareAddress())));
        log.info(String.format("MTU: %s", networkInterface.getMTU()));
    }
}

