/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl.apache;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.transport.impl.apache.HeaderUtil;
import org.fourthline.cling.transport.impl.apache.StreamClientConfigurationImpl;
import org.fourthline.cling.transport.spi.AbstractStreamClient;
import org.fourthline.cling.transport.spi.InitializationException;
import org.fourthline.cling.transport.spi.StreamClient;

public class StreamClientImpl
extends AbstractStreamClient<StreamClientConfigurationImpl, HttpUriRequest> {
    private static final Logger log = Logger.getLogger(StreamClient.class.getName());
    protected final StreamClientConfigurationImpl configuration;
    protected final PoolingClientConnectionManager clientConnectionManager;
    protected final DefaultHttpClient httpClient;
    protected final HttpParams globalParams = new BasicHttpParams();

    public StreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        HttpProtocolParams.setContentCharset(this.globalParams, this.getConfiguration().getContentCharset());
        HttpProtocolParams.setUseExpectContinue(this.globalParams, false);
        HttpConnectionParams.setConnectionTimeout(this.globalParams, (this.getConfiguration().getTimeoutSeconds() + 5) * 1000);
        HttpConnectionParams.setSoTimeout(this.globalParams, (this.getConfiguration().getTimeoutSeconds() + 5) * 1000);
        HttpConnectionParams.setStaleCheckingEnabled(this.globalParams, this.getConfiguration().getStaleCheckingEnabled());
        if (this.getConfiguration().getSocketBufferSize() != -1) {
            HttpConnectionParams.setSocketBufferSize(this.globalParams, this.getConfiguration().getSocketBufferSize());
        }
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
        this.clientConnectionManager = new PoolingClientConnectionManager(registry);
        this.clientConnectionManager.setMaxTotal(this.getConfiguration().getMaxTotalConnections());
        this.clientConnectionManager.setDefaultMaxPerRoute(this.getConfiguration().getMaxTotalPerRoute());
        this.httpClient = new DefaultHttpClient(this.clientConnectionManager, this.globalParams);
        if (this.getConfiguration().getRequestRetryCount() != -1) {
            this.httpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(this.getConfiguration().getRequestRetryCount(), false));
        }
    }

    @Override
    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    protected HttpUriRequest createRequest(StreamRequestMessage requestMessage) {
        HttpUriRequest request;
        UpnpRequest requestOperation = (UpnpRequest)requestMessage.getOperation();
        switch (requestOperation.getMethod()) {
            case GET: {
                request = new HttpGet(requestOperation.getURI());
                break;
            }
            case SUBSCRIBE: {
                request = new HttpGet(requestOperation.getURI()){

                    @Override
                    public String getMethod() {
                        return UpnpRequest.Method.SUBSCRIBE.getHttpName();
                    }
                };
                break;
            }
            case UNSUBSCRIBE: {
                request = new HttpGet(requestOperation.getURI()){

                    @Override
                    public String getMethod() {
                        return UpnpRequest.Method.UNSUBSCRIBE.getHttpName();
                    }
                };
                break;
            }
            case POST: {
                HttpPost post = new HttpPost(requestOperation.getURI());
                post.setEntity(this.createHttpRequestEntity(requestMessage));
                request = post;
                break;
            }
            case NOTIFY: {
                HttpPost notify = new HttpPost(requestOperation.getURI()){

                    @Override
                    public String getMethod() {
                        return UpnpRequest.Method.NOTIFY.getHttpName();
                    }
                };
                notify.setEntity(this.createHttpRequestEntity(requestMessage));
                request = notify;
                break;
            }
            default: {
                throw new RuntimeException("Unknown HTTP method: " + requestOperation.getHttpMethodName());
            }
        }
        request.setParams(this.getRequestParams(requestMessage));
        HeaderUtil.add(request, requestMessage.getHeaders());
        return request;
    }

    @Override
    protected Callable<StreamResponseMessage> createCallable(final StreamRequestMessage requestMessage, final HttpUriRequest request) {
        return new Callable<StreamResponseMessage>(){

            @Override
            public StreamResponseMessage call() throws Exception {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Sending HTTP request: " + requestMessage);
                }
                return StreamClientImpl.this.httpClient.execute(request, StreamClientImpl.this.createResponseHandler());
            }
        };
    }

    @Override
    protected void abort(HttpUriRequest request) {
        request.abort();
    }

    @Override
    protected boolean logExecutionException(Throwable t) {
        if (t instanceof IllegalStateException) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Illegal state: " + t.getMessage());
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Shutting down HTTP client connection manager/pool");
        }
        this.clientConnectionManager.shutdown();
    }

    protected HttpEntity createHttpRequestEntity(UpnpMessage upnpMessage) {
        if (upnpMessage.getBodyType().equals((Object)UpnpMessage.BodyType.BYTES)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Preparing HTTP request entity as byte[]");
            }
            return new ByteArrayEntity(upnpMessage.getBodyBytes());
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Preparing HTTP request entity as string");
        }
        try {
            String charset = upnpMessage.getContentTypeCharset();
            return new StringEntity(upnpMessage.getBodyString(), charset != null ? charset : "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected ResponseHandler<StreamResponseMessage> createResponseHandler() {
        return new ResponseHandler<StreamResponseMessage>(){

            @Override
            public StreamResponseMessage handleResponse(HttpResponse httpResponse) throws IOException {
                StatusLine statusLine = httpResponse.getStatusLine();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Received HTTP response: " + statusLine);
                }
                UpnpResponse responseOperation = new UpnpResponse(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
                responseMessage.setHeaders(new UpnpHeaders(HeaderUtil.get(httpResponse)));
                HttpEntity entity = httpResponse.getEntity();
                if (entity == null || entity.getContentLength() == 0L) {
                    log.fine("HTTP response message has no entity");
                    return responseMessage;
                }
                byte[] data = EntityUtils.toByteArray(entity);
                if (data != null) {
                    if (responseMessage.isContentTypeMissingOrText()) {
                        log.fine("HTTP response message contains text entity");
                        responseMessage.setBodyCharacters(data);
                    } else {
                        log.fine("HTTP response message contains binary entity");
                        responseMessage.setBody(UpnpMessage.BodyType.BYTES, data);
                    }
                } else {
                    log.fine("HTTP response message has no entity");
                }
                return responseMessage;
            }
        };
    }

    protected HttpParams getRequestParams(StreamRequestMessage requestMessage) {
        BasicHttpParams localParams = new BasicHttpParams();
        localParams.setParameter("http.protocol.version", ((UpnpRequest)requestMessage.getOperation()).getHttpMinorVersion() == 0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1);
        if (!requestMessage.getHeaders().containsKey(UpnpHeader.Type.USER_AGENT)) {
            HttpProtocolParams.setUserAgent(localParams, this.getConfiguration().getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
        }
        return new DefaultedHttpParams(localParams, this.globalParams);
    }
}

