/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl.apache;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpRequestFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.fourthline.cling.model.message.Connection;
import org.fourthline.cling.transport.Router;
import org.fourthline.cling.transport.impl.apache.HttpServerConnectionUpnpStream;
import org.fourthline.cling.transport.impl.apache.StreamServerConfigurationImpl;
import org.fourthline.cling.transport.impl.apache.UpnpHttpRequestFactory;
import org.fourthline.cling.transport.spi.InitializationException;
import org.fourthline.cling.transport.spi.StreamServer;

public class StreamServerImpl
implements StreamServer<StreamServerConfigurationImpl> {
    private static final Logger log = Logger.getLogger(StreamServer.class.getName());
    protected final StreamServerConfigurationImpl configuration;
    protected Router router;
    protected ServerSocket serverSocket;
    protected HttpParams globalParams = new BasicHttpParams();
    private volatile boolean stopped = false;

    public StreamServerImpl(StreamServerConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public StreamServerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void init(InetAddress bindAddress, Router router) throws InitializationException {
        try {
            this.router = router;
            this.serverSocket = new ServerSocket(this.configuration.getListenPort(), this.configuration.getTcpConnectionBacklog(), bindAddress);
            log.info("Created socket (for receiving TCP streams) on: " + this.serverSocket.getLocalSocketAddress());
            this.globalParams.setIntParameter("http.socket.timeout", this.configuration.getDataWaitTimeoutSeconds() * 1000).setIntParameter("http.socket.buffer-size", this.configuration.getBufferSizeKilobytes() * 1024).setBooleanParameter("http.connection.stalecheck", this.configuration.isStaleConnectionCheck()).setBooleanParameter("http.tcp.nodelay", this.configuration.isTcpNoDelay());
        }
        catch (Exception ex) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName() + ": " + ex.toString(), ex);
        }
    }

    @Override
    public synchronized int getPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public synchronized void stop() {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            log.fine("Exception closing streaming server socket: " + ex);
        }
    }

    @Override
    public void run() {
        log.fine("Entering blocking receiving loop, listening for HTTP stream requests on: " + this.serverSocket.getLocalSocketAddress());
        while (!this.stopped) {
            try {
                final Socket clientSocket = this.serverSocket.accept();
                final DefaultHttpServerConnection httpServerConnection = new DefaultHttpServerConnection(){

                    @Override
                    protected HttpRequestFactory createHttpRequestFactory() {
                        return new UpnpHttpRequestFactory();
                    }
                };
                log.fine("Incoming connection from: " + clientSocket.getInetAddress());
                httpServerConnection.bind(clientSocket, this.globalParams);
                HttpServerConnectionUpnpStream connectionStream = new HttpServerConnectionUpnpStream(this.router.getProtocolFactory(), httpServerConnection, this.globalParams){

                    @Override
                    protected Connection createConnection() {
                        return new ApacheServerConnection(clientSocket, httpServerConnection);
                    }
                };
                this.router.received(connectionStream);
            }
            catch (InterruptedIOException ex) {
                log.fine("I/O has been interrupted, stopping receiving loop, bytes transfered: " + ex.bytesTransferred);
                break;
            }
            catch (SocketException ex) {
                if (this.stopped) break;
                log.fine("Exception using server socket: " + ex.getMessage());
                break;
            }
            catch (IOException ex) {
                log.fine("Exception initializing receiving loop: " + ex.getMessage());
                break;
            }
        }
        try {
            log.fine("Receiving loop stopped");
            if (!this.serverSocket.isClosed()) {
                log.fine("Closing streaming server socket");
                this.serverSocket.close();
            }
        }
        catch (Exception ex) {
            log.info("Exception closing streaming server socket: " + ex.getMessage());
        }
    }

    protected boolean isConnectionOpen(Socket socket) {
        try {
            return this.isConnectionOpen(socket, " ".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean isConnectionOpen(Socket socket, byte[] heartbeat) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking if client connection is still open on: " + socket.getRemoteSocketAddress());
        }
        try {
            socket.getOutputStream().write(heartbeat);
            socket.getOutputStream().flush();
            return true;
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Client connection has been closed: " + socket.getRemoteSocketAddress());
            }
            return false;
        }
    }

    protected class ApacheServerConnection
    implements Connection {
        protected Socket socket;
        protected DefaultHttpServerConnection connection;

        public ApacheServerConnection(Socket socket, DefaultHttpServerConnection connection) {
            this.socket = socket;
            this.connection = connection;
        }

        @Override
        public boolean isOpen() {
            return StreamServerImpl.this.isConnectionOpen(this.socket);
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.connection.getRemoteAddress();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.connection.getLocalAddress();
        }
    }
}

