/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl.apache;

import org.apache.http.HttpRequest;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.RequestLine;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;

public class UpnpHttpRequestFactory
extends DefaultHttpRequestFactory {
    private static final String[] BASIC = new String[]{"SUBSCRIBE", "UNSUBSCRIBE"};
    private static final String[] WITH_ENTITY = new String[]{"NOTIFY"};

    private static boolean isOneOf(String[] methods, String method) {
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HttpRequest newHttpRequest(RequestLine requestline) throws MethodNotSupportedException {
        if (requestline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        String method = requestline.getMethod();
        String uri = requestline.getUri();
        return this.newHttpRequest(method, uri);
    }

    @Override
    public HttpRequest newHttpRequest(String method, String uri) throws MethodNotSupportedException {
        if (UpnpHttpRequestFactory.isOneOf(BASIC, method)) {
            return new BasicHttpRequest(method, uri);
        }
        if (UpnpHttpRequestFactory.isOneOf(WITH_ENTITY, method)) {
            return new BasicHttpEntityEnclosingRequest(method, uri);
        }
        return super.newHttpRequest(method, uri);
    }
}

