/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.common.tools.boot.updater.DependencyException;
import org.tensin.common.tools.boot.updater.IAdapterInput;
import org.tensin.common.tools.boot.updater.IAdapterOutput;
import org.tensin.common.tools.boot.updater.JarContainer;

public class AdapterLTPXml
implements IAdapterInput,
IAdapterOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterLTPXml.class);
    private String destFileName;

    public static AdapterLTPXml buildAdapter(String destFileName) {
        AdapterLTPXml adapter = new AdapterLTPXml();
        adapter.setDestFileName(destFileName);
        return adapter;
    }

    @Override
    public void generate(Collection<JarContainer> jars) throws DependencyException {
        Element racine = new Element("project");
        Document document = new Document(racine);
        Element dependencies = new Element("dependencies");
        racine.addContent((Content)dependencies);
        for (JarContainer jar : JarContainer.fusion(jars)) {
            Element dependency = new Element("dependency");
            dependencies.addContent((Content)dependency);
            String groupId = jar.getGroupId();
            if (StringUtils.isEmpty((CharSequence)groupId)) {
                groupId = JarContainer.getMavenGroupIdDatabase().get(jar.getArtifactId());
            }
            if (StringUtils.isEmpty((CharSequence)groupId)) {
                groupId = "";
            }
            dependency.setAttribute("groupId", groupId);
            dependency.setAttribute("artifactId", jar.getArtifactId());
            dependency.setAttribute("version", jar.getVersion());
            dependency.setAttribute("destination", this.updateDestinationWithStartConstants(jar));
            dependency.setAttribute("modules", jar.getModules());
            dependency.setAttribute("description", jar.getDescription());
            dependency.setAttribute("path", jar.getPath());
            dependency.setAttribute("key", jar.getKey());
            if (jar.isActif()) continue;
            dependency.setAttribute("actif", String.valueOf(false));
        }
        XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
        try {
            sortie.output(document, (OutputStream)System.out);
        }
        catch (IOException e) {
            throw new DependencyException(e);
        }
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    @Override
    public String getName() {
        return "Load and save from and to LTP internal XML file";
    }

    @Override
    public Collection<JarContainer> load() throws DependencyException {
        ArrayList<JarContainer> result = new ArrayList<JarContainer>();
        SAXBuilder sxb = new SAXBuilder();
        try {
            Document document = sxb.build(new File(this.destFileName));
            Element racine = document.getRootElement();
            Element dependencies = racine.getChild("dependencies", racine.getNamespace());
            List dependency = dependencies.getChildren("dependency", racine.getNamespace());
            for (Element element : dependency) {
                JarContainer jar = new JarContainer(AdapterLTPXml.class);
                jar.setGroupId(element.getAttributeValue("groupId", racine.getNamespace(), ""));
                jar.setArtifactId(element.getAttributeValue("artifactId", racine.getNamespace(), ""));
                jar.setVersion(element.getAttributeValue("version", racine.getNamespace(), ""));
                jar.setDescription(element.getAttributeValue("description", racine.getNamespace(), ""));
                jar.setDestinations(element.getAttributeValue("destination", racine.getNamespace(), ""));
                jar.setModules(element.getAttributeValue("modules", racine.getNamespace(), ""));
                jar.setPath(element.getAttributeValue("path", racine.getNamespace(), ""));
                jar.setKey(element.getAttributeValue("key", racine.getNamespace(), ""));
                jar.setActif(element.getAttributeValue("key", racine.getNamespace(), "true"));
                result.add(jar);
            }
        }
        catch (JDOMException e) {
            throw new DependencyException(e);
        }
        catch (IOException e) {
            throw new DependencyException(e);
        }
        return result;
    }

    public void setDestFileName(String destFileName) {
        this.destFileName = destFileName;
    }

    private String updateDestinationWithStartConstants(JarContainer jar) {
        String key = jar.getKey();
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            key = jar.getJarName();
        }
        return jar.getDestinations();
    }
}

