/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tensin.common.tools.boot.updater.AdapterEclipseClasspath;
import org.tensin.common.tools.boot.updater.JarContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class EclipseClasspathHandler
extends DefaultHandler {
    private static final String XML_CLASSPATH_BALISE = "classpath";
    private static final String XML_CLASSPATHENTRY_BALISE = "classpathentry";
    private static final String XML_CLASSPATHENTRY_ATTRIBUTE_KIND = "kind";
    private static final String XML_CLASSPATHENTRY_ATTRIBUTE_PATH = "path";
    private final List<JarContainer> results = new ArrayList<JarContainer>();

    EclipseClasspathHandler() {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.printSAXException(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        String message = "*** Erreur fatale ***\n";
        message = message + this.message(exception);
        SAXException se = new SAXException(message, exception);
        throw se;
    }

    public List<JarContainer> getResults() {
        return this.results;
    }

    protected String message(SAXParseException e) {
        String message = "Message : " + e.getMessage() + "\n";
        message = message + "Ligne " + e.getLineNumber() + ", colonne " + e.getColumnNumber() + "\n";
        message = message + "Public id : " + e.getPublicId() + "\n";
        message = message + "System id : " + e.getSystemId();
        return message;
    }

    protected void printSAXException(SAXParseException e) {
        if (e.getException() != null) {
            e.getException().printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!qName.equalsIgnoreCase(XML_CLASSPATH_BALISE) && qName.equalsIgnoreCase(XML_CLASSPATHENTRY_BALISE)) {
            String path;
            String kind = attributes.getValue(XML_CLASSPATHENTRY_ATTRIBUTE_KIND);
            if (kind.equalsIgnoreCase("lib")) {
                String path2 = attributes.getValue(XML_CLASSPATHENTRY_ATTRIBUTE_PATH);
                File f = new File(path2);
                JarContainer jar = new JarContainer(AdapterEclipseClasspath.class);
                jar.setJarName(f.getName());
                this.results.add(jar);
            } else if (!kind.equalsIgnoreCase("var") || StringUtils.isEmpty((CharSequence)(path = attributes.getValue(XML_CLASSPATHENTRY_ATTRIBUTE_PATH))) || !path.endsWith("-sources.jar")) {
                // empty if block
            }
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.printSAXException(exception);
    }
}

