/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.ISonosIndexer;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.model.Entry;

public class SonosIndexer
implements ISonosIndexer {
    private static final Directory index = new RAMDirectory();
    private static final StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_36);
    private static final IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_36, (Analyzer)analyzer);
    private static IndexWriter w = null;
    private static BlockingQueue<Entry> queue = new LinkedBlockingQueue<Entry>();
    private static final Logger LOGGER = LoggerFactory.getLogger(SonosIndexer.class);
    private IndexingThread indexingThread;
    private static SonosIndexer INSTANCE = new SonosIndexer();

    public static ISonosIndexer getInstance() {
        return INSTANCE;
    }

    private IndexWriter getIndexWriter() throws SonosException {
        if (w == null) {
            try {
                w = new IndexWriter(index, config);
            }
            catch (CorruptIndexException e) {
                throw new SonosException(e);
            }
            catch (LockObtainFailedException e) {
                throw new SonosException(e);
            }
            catch (IOException e) {
                throw new SonosException(e);
            }
        }
        return w;
    }

    @Override
    public void index(Entry entry) throws SonosException {
        queue.offer(entry);
    }

    @Override
    public void init() {
        new Thread(this.indexingThread).start();
    }

    @Override
    public Collection<Document> search(String queryString) throws SonosException {
        ArrayList<Document> results = new ArrayList<Document>();
        try {
            Query q = new QueryParser(Version.LUCENE_36, "title", (Analyzer)analyzer).parse(queryString);
            int hitsPerPage = 1000;
            IndexReader reader = IndexReader.open((Directory)index);
            IndexSearcher searcher = new IndexSearcher(reader);
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)hitsPerPage, (boolean)true);
            searcher.search(q, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            System.out.println("Found " + hits.length + " hits.");
            for (int i = 0; i < hits.length; ++i) {
                int docId = hits[i].doc;
                Document d = searcher.doc(docId);
                results.add(d);
                System.out.println(i + 1 + ". " + d.get("title"));
            }
            searcher.close();
        }
        catch (ParseException e) {
            throw new SonosException(e);
        }
        catch (IOException e) {
            throw new SonosException(e);
        }
        return results;
    }

    @Override
    public void shutdown() {
    }

    private class IndexingThread
    implements Runnable {
        private final boolean active = true;

        private IndexingThread() {
        }

        @Override
        public void run() {
            IndexWriter indexWriter = null;
            try {
                indexWriter = SonosIndexer.this.getIndexWriter();
            }
            catch (SonosException e) {
                LOGGER.error("Error while getting index writer", e);
            }
            Entry entry = null;
            while (true) {
                try {
                    while (true) {
                        entry = (Entry)queue.take();
                        Document doc = new Document();
                        doc.add((Fieldable)new Field("album", entry.getAlbum(), Field.Store.YES, Field.Index.ANALYZED));
                        doc.add((Fieldable)new Field("artist", entry.getCreator(), Field.Store.YES, Field.Index.ANALYZED));
                        doc.add((Fieldable)new Field("title", entry.getTitle(), Field.Store.YES, Field.Index.ANALYZED));
                        doc.add((Fieldable)new Field("albumartist", entry.getAlbumArtist(), Field.Store.YES, Field.Index.ANALYZED));
                        doc.add((Fieldable)new Field("id", entry.getId(), Field.Store.YES, Field.Index.ANALYZED));
                        doc.add((Fieldable)new Field("upnpclass", entry.getUpnpClass(), Field.Store.YES, Field.Index.ANALYZED));
                        indexWriter.addDocument(doc);
                        indexWriter.commit();
                    }
                }
                catch (CorruptIndexException e) {
                    LOGGER.error("Error while processing entry [" + entry.toString() + "]", e);
                    continue;
                }
                catch (LockObtainFailedException e) {
                    LOGGER.error("Error while processing entry [" + entry.toString() + "]", e);
                    continue;
                }
                catch (IOException e) {
                    LOGGER.error("Error while processing entry [" + entry.toString() + "]", e);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupted while processing entry", e);
                    continue;
                }
                break;
            }
        }
    }
}

