/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Service;
import org.tensin.sonos.control.AbstractAudioInService;
import org.tensin.sonos.control.SonosActionInvocation;
import org.tensin.sonos.model.AudioInputAttributes;
import org.tensin.sonos.model.LineLevel;

public class AudioInService
extends AbstractAudioInService {
    public AudioInService(UpnpService upnpService, Service service) {
        super(upnpService, service, "urn:schemas-upnp-org:service:AudioIn:1");
    }

    public AudioInputAttributes getAudioInputAttributes() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetAudioInputAttributes");
        this.executeImmediate(message);
        return new AudioInputAttributes(message.getOutputAsString("AudioInputName"), message.getOutputAsString("Icon"));
    }

    public LineLevel getLineInLevel() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetLineInLevel");
        this.executeImmediate(message);
        return new LineLevel(Integer.parseInt(message.getOutputAsString("CurrentLeftLineInLevel")), Integer.parseInt(message.getOutputAsString("CurrentRightLineInLevel")));
    }

    public void handleStateVariableEvent(String varName, String newValue) {
    }

    public void setAudioInputAttributes(String name, String iconUri) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetAudioInputAttributes");
        message.setInput("DesiredName", name);
        message.setInput("DesiredIcon", iconUri);
        this.execute(message);
    }

    public void setLineInLevel(int leftLevel, int rightLevel) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetLineInLevel");
        message.setInput("DesiredLeftLineInLevel", leftLevel);
        message.setInput("DesiredRightLineInLevel", rightLevel);
        this.execute(message);
    }

    public String startTransmissionToGroup(String groupId) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "StartTransmissionToGroup");
        message.setInput("CoordinatorID", groupId);
        this.executeImmediate(message);
        return message.getOutputAsString("CurrentTransportSettings");
    }

    public void stopTransmissionToGroup(String groupId) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "StopTransmissionToGroup");
        message.setInput("CoordinatorID", groupId);
        this.execute(message);
    }
}

