/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.RenderingControlListener;
import org.tensin.sonos.control.SonosActionInvocation;
import org.tensin.sonos.xml.RenderingControlEventHandler;
import org.tensin.sonos.xml.ResultParser;
import org.xml.sax.SAXException;

public class RenderingControlService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderingControlService.class);
    private final Map<RenderingControlEventHandler.RenderingControlEventType, String> state = new HashMap<RenderingControlEventHandler.RenderingControlEventType, String>();
    private final List<RenderingControlListener> listeners = new ArrayList<RenderingControlListener>();

    protected RenderingControlService(UpnpService upnpService, Service service) {
        super(upnpService, service, "urn:schemas-upnp-org:service:RenderingControl:1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RenderingControlListener l) {
        List<RenderingControlListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(Set<RenderingControlEventHandler.RenderingControlEventType> events) {
        List<RenderingControlListener> list = this.listeners;
        synchronized (list) {
            for (RenderingControlListener l : this.listeners) {
                l.valuesChanged(events, this);
            }
        }
    }

    public boolean getMute() {
        String mute_master = this.state.get((Object)RenderingControlEventHandler.RenderingControlEventType.MUTE_MASTER);
        if (mute_master == null) {
            SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetMute");
            message.setInput("InstanceID", "0");
            message.setInput("Channel", "Master");
            this.executeImmediate(message);
            this.state.put(RenderingControlEventHandler.RenderingControlEventType.MUTE_MASTER, message.getOutputAsString("CurrentMute"));
        }
        return Boolean.parseBoolean(this.state.get((Object)RenderingControlEventHandler.RenderingControlEventType.MUTE_MASTER));
    }

    public int getVolume() {
        String volume_master = this.state.get((Object)RenderingControlEventHandler.RenderingControlEventType.VOLUME_MASTER);
        if (volume_master == null) {
            SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetVolume");
            message.setInput("InstanceID", "0");
            message.setInput("Channel", "Master");
            this.executeImmediate(message);
            this.state.put(RenderingControlEventHandler.RenderingControlEventType.VOLUME_MASTER, message.getOutputAsString("CurrentVolume"));
        }
        return Integer.parseInt(this.state.get((Object)RenderingControlEventHandler.RenderingControlEventType.VOLUME_MASTER));
    }

    public void handleStateVariableEvent(String varName, String newValue) {
        LOGGER.debug("received event " + varName + ": " + newValue);
        try {
            Map<RenderingControlEventHandler.RenderingControlEventType, String> changes = ResultParser.parseRenderingControlEvent(newValue);
            this.state.putAll(changes);
            this.fireChangeEvent(changes.keySet());
        }
        catch (SAXException e) {
            LOGGER.error("Ignored event due to SAX parsing error: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RenderingControlListener l) {
        List<RenderingControlListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public void setCrossFade(boolean crossfade) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetCrossfadeMode");
        message.setInput("InstanceID", "0");
        message.setInput("DesiredMute", crossfade ? "1" : "0");
        this.execute(message);
    }

    public void setMute(boolean mute) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetMute");
        message.setInput("InstanceID", "0");
        message.setInput("Channel", "Master");
        message.setInput("DesiredMute", mute ? "1" : "0");
        this.execute(message);
    }

    public void setVolume(int vol) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetVolume");
        message.setInput("InstanceID", "0");
        message.setInput("Channel", "Master");
        message.setInput("DesiredVolume", String.valueOf(vol));
        this.execute(message);
    }
}

