/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.helpers;

import org.fourthline.cling.model.meta.Action;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.types.ServiceType;
import org.tensin.sonos.helpers.CollectionHelper;

public class RemoteDeviceHelper {
    public static String dumpRemoteDevice(RemoteDevice device) {
        StringBuilder sb = new StringBuilder();
        sb.append(device.toString()).append("\n");
        sb.append("  Details :").append("\n");
        sb.append("    Name [").append(device.getDetails().getFriendlyName()).append("]").append("\n");
        sb.append("    Serial Number [").append(device.getDetails().getSerialNumber()).append("]").append("\n");
        sb.append("    UPC [").append(device.getDetails().getUpc()).append("]").append("\n");
        sb.append("    Base URL [").append(device.getDetails().getBaseURL()).append("]").append("\n");
        sb.append("    URI [").append(device.getDetails().getPresentationURI()).append("]").append("\n");
        sb.append("    Manufacturer :").append("\n");
        sb.append("      Manufacturer [").append(device.getDetails().getManufacturerDetails().getManufacturer()).append("]").append("\n");
        sb.append("      Manufacturer URI [").append(device.getDetails().getManufacturerDetails().getManufacturerURI()).append("]").append("\n");
        sb.append("    Model :").append("\n");
        sb.append("      Name [").append(device.getDetails().getModelDetails().getModelName()).append("]").append("\n");
        sb.append("      Description [").append(device.getDetails().getModelDetails().getModelDescription()).append("]").append("\n");
        sb.append("      Model Number [").append(device.getDetails().getModelDetails().getModelNumber()).append("]").append("\n");
        sb.append("      Model URI [").append(device.getDetails().getModelDetails().getModelURI()).append("]").append("\n");
        sb.append("  Identity :").append("\n");
        sb.append("    UDN [").append(((RemoteDeviceIdentity)device.getIdentity()).getUdn()).append("]").append("\n");
        sb.append("    Descriptor URL [").append(((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL()).append("]").append("\n");
        sb.append("    Discovered on local address [").append(((RemoteDeviceIdentity)device.getIdentity()).getDiscoveredOnLocalAddress()).append("]").append("\n");
        sb.append("    Interface MAC addresss [").append(((RemoteDeviceIdentity)device.getIdentity()).getInterfaceMacAddress()).append("]").append("\n");
        sb.append("    Max age (seconds) [").append(((RemoteDeviceIdentity)device.getIdentity()).getMaxAgeSeconds()).append("]").append("\n");
        sb.append("    WoL bytes [").append(((RemoteDeviceIdentity)device.getIdentity()).getWakeOnLANBytes()).append("]").append("\n");
        sb.append("  Identity [").append(device.getVersion().toString()).append("]").append("\n");
        sb.append("  Embedded devices :").append("\n");
        for (RemoteDevice remoteDevice : (RemoteDevice[])device.findEmbeddedDevices()) {
            sb.append("    - ").append(remoteDevice.toString()).append("\n");
        }
        sb.append("  Services :").append("\n");
        for (RemoteService service : (RemoteService[])device.findServices()) {
            sb.append("    - ").append(service.getServiceId()).append("\n");
            sb.append("        Actions :").append("\n");
            for (Action action : service.getActions()) {
                sb.append("          - ").append(action.getName()).append(" (").append(CollectionHelper.singleDump(action.getArguments())).append(")").append("\n");
            }
        }
        sb.append("  Services types:").append("\n");
        for (ServiceType serviceType : device.findServiceTypes()) {
            sb.append("    - ").append(serviceType.toString()).append("\n");
        }
        return sb.toString();
    }
}

