/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.model;

import java.util.ArrayList;
import java.util.List;
import org.tensin.sonos.model.Entry;
import org.tensin.sonos.model.QueueModelListener;

public class QueueModel {
    private List<Entry> entries = new ArrayList<Entry>();
    private int nowPlaying = -1;
    private List<QueueModelListener> listeners = new ArrayList<QueueModelListener>();

    public void addQueueModelListener(QueueModelListener listener) {
        this.listeners.add(listener);
    }

    private void fireEntriesChanged() {
        for (QueueModelListener listener : this.listeners) {
            listener.entriesChanged(this);
        }
    }

    private void fireNowPlayingChanged() {
        for (QueueModelListener listener : this.listeners) {
            listener.nowPlayingChanged(this);
        }
    }

    public Entry getEntryAt(int index) {
        return this.entries.get(index);
    }

    public int getNowPlaying() {
        return this.nowPlaying;
    }

    public int getSize() {
        return this.entries.size();
    }

    public String getTitle(int index) {
        return this.entries.get(index).getTitle();
    }

    public int indexOf(Entry target) {
        for (int i = 0; i < this.getSize(); ++i) {
            Entry entry = this.getEntryAt(i);
            if (!entry.getId().equals(target)) continue;
            return i;
        }
        return -1;
    }

    public boolean isNowPlaying(int index) {
        return index == this.nowPlaying;
    }

    public void removeQueueModelListener(QueueModelListener listener) {
        this.listeners.remove(listener);
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
        if (this.nowPlaying >= this.entries.size() - 1) {
            this.setNowPlaying(-1);
        }
        this.fireEntriesChanged();
    }

    public void setNowPlaying(int i) {
        this.nowPlaying = i;
        this.fireNowPlayingChanged();
    }
}

