/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.model;

import org.tensin.sonos.helpers.TimeUtilities;
import org.tensin.sonos.model.SeekMode;
import org.tensin.sonos.model.SeekTarget;

public class SeekTargetFactory {
    public static SeekTarget createAbsCountSeekTarget(int target) {
        return new SeekTarget(SeekMode.ABS_COUNT, Integer.toString(target + 1));
    }

    public static SeekTarget createAbsTimeSeekTarget(long absTime) {
        return new SeekTarget(SeekMode.ABS_TIME, TimeUtilities.convertLongToDuration(absTime));
    }

    public static SeekTarget createRelCountSeekTarget(int target) {
        return new SeekTarget(SeekMode.REL_COUNT, Integer.toString(target + 1));
    }

    public static SeekTarget createRelTimeSeekTarget(long relTime) {
        return new SeekTarget(SeekMode.REL_TIME, TimeUtilities.convertLongToDuration(relTime));
    }

    public static SeekTarget createTrackSeekTarget(int track) {
        return new SeekTarget(SeekMode.TRACK_NR, Integer.toString(track + 1));
    }
}

