/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.model;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.model.ZoneGroup;
import org.tensin.sonos.model.ZoneGroupState;
import org.tensin.sonos.model.ZoneGroupStateModelListener;

public class ZoneGroupStateModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZoneGroupStateModel.class);
    private ZoneGroupState oldGroupState = new ZoneGroupState(new ArrayList<ZoneGroup>());
    private final List<ZoneGroupStateModelListener> listeners = new ArrayList<ZoneGroupStateModelListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ZoneGroupStateModelListener l) {
        List<ZoneGroupStateModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    protected void fireGroupAdded(ZoneGroup group) {
        LOGGER.info("ADDING GROUP: " + group.getId());
        for (ZoneGroupStateModelListener l : this.listeners) {
            l.zoneGroupAdded(group, this);
        }
    }

    protected void fireGroupMembershipChanged(ZoneGroup group) {
        LOGGER.info("CHANGING GROUP: " + group.getId());
        for (ZoneGroupStateModelListener l : this.listeners) {
            l.zoneGroupMembersChanged(group, this);
        }
    }

    protected void fireGroupRemoved(ZoneGroup group) {
        LOGGER.info("REMOVING GROUP: " + group.getId());
        for (ZoneGroupStateModelListener l : this.listeners) {
            l.zoneGroupRemoved(group, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleGroupUpdate(ZoneGroupState newGroupState) {
        List<ZoneGroupStateModelListener> list = this.listeners;
        synchronized (list) {
            ZoneGroupState ozgstate = this.oldGroupState;
            this.oldGroupState = newGroupState;
            for (ZoneGroup oldGroup : ozgstate.getGroups()) {
                if (newGroupState.getGroups().contains(oldGroup)) continue;
                this.fireGroupRemoved(oldGroup);
            }
            for (ZoneGroup newGroup : newGroupState.getGroups()) {
                if (ozgstate.getGroups().contains(newGroup)) continue;
                this.fireGroupAdded(newGroup);
            }
            for (ZoneGroup newGroup : newGroupState.getGroups()) {
                for (ZoneGroup oldGroup : ozgstate.getGroups()) {
                    if (!oldGroup.equals(newGroup) || oldGroup.getMembers().containsAll(newGroup.getMembers()) && newGroup.getMembers().containsAll(oldGroup.getMembers())) continue;
                    this.fireGroupMembershipChanged(newGroup);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ZoneGroupStateModelListener l) {
        List<ZoneGroupStateModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }
}

