/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.run;

import org.tensin.sonos.SonosException;
import org.tensin.sonos.boot.CLIBootConstants;
import org.tensin.sonos.boot.ClasspathBooter;
import org.tensin.sonos.commander.CLIController;
import org.tensin.sonos.helpers.SystemHelper;

public class Sonos {
    private static final String SONOS_MAIN_CLASS = CLIController.class.getName();
    private static final String SONOS_BOOT_JAR = "sonos-java-.*\\.jar";
    private static final String FAKE_LOG_LABEL = "0 [main] INFO org.tensin.sonos.commander.SonosCommander  - ";
    private static final String LINE_SEPARATOR = "\n     ";

    public static void main(String[] args) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        SystemHelper systemHelper = new SystemHelper();
        try {
            ClasspathBooter cb = new ClasspathBooter(SONOS_BOOT_JAR, "SONOS-Command Line Interface");
            cb.addJarsToClasspath(CLIBootConstants.LIBS);
            systemHelper.outln("0 [main] INFO org.tensin.sonos.commander.SonosCommander  - Classpath :" + cb.displayClasspath(LINE_SEPARATOR));
            systemHelper.outln("0 [main] INFO org.tensin.sonos.commander.SonosCommander  - Manifest :" + cb.getManifest(SONOS_BOOT_JAR, LINE_SEPARATOR));
            cb.execute(SONOS_MAIN_CLASS, "main", new Class[]{args.getClass()}, new Object[]{args});
        }
        catch (SonosException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            systemHelper.exit(0);
        }
    }
}

