/* 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 20015–2018 by Michael Hoffer
 * 
 * This file is part of SonoAir.
 *
 * SonoAir is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3
 * as published by the Free Software Foundation.
 * 
 * see: http://opensource.org/licenses/GPL-3.0
 *
 * VRL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This version of SonoAir includes copyright notice and attribution requirements.
 * According to the GPL this information must be displayed even if you modify
 * the source code of SonoAir. Neither the SonoAir attribution icon(s) nor any
 * copyright statement/attribution may be removed.
 */
package eu.mihosoft.sonoair;

import eu.mihosoft.vrl.base.ConfigurationFile;
import eu.mihosoft.vrl.base.IOUtil;
import eu.mihosoft.vrl.base.VRL;
import java.io.File;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;

/**
 *
 * @author Michael Hoffer &lt;info@michaelhoffer.de&gt;
 */
public class ConfigController {

    public static final String KEY_DISCOVERY_TIMEOUT = "sonoair:discovery-timeout";
    public static final String KEY_ENABLE_DEBUG = "sonoair:enable-debug";
    public static final String KEY_DISABLE_EXPERIMENTAL_BUILD_WARNING_DIALOG
            = "sonoair:disable-experimental-build-warning-dialog";
    public static final String KEY_START_MINIMIZED = "sonoair:start-minimized";

    private final LongProperty discoveryTimeoutProperty = new SimpleLongProperty(10000);
    private final BooleanProperty enableDebugProperty = new SimpleBooleanProperty(false);

    private final BooleanProperty disableExperimentalWarningDialogProperty
            = new SimpleBooleanProperty(false);

    private final BooleanProperty startMinimizedProperty = new SimpleBooleanProperty(false);

    private final File configFile;
    private final ConfigurationFile config;

    public ConfigController() {
        configFile = new File(
                VRL.getPropertyFolderManager().
                        getConfigFolder(), "config.xml");

        config = IOUtil.newConfigurationFile(configFile);

        if (!config.load()) {
            System.err.println(
                    ">> WARNING: cannot load config file " + configFile);
        }

        initListeners();
    }

    private void initListeners() {

        getDiscoveryTimeoutProperty().addListener((ov, oldV, newV) -> {
            config.setProperty(KEY_DISCOVERY_TIMEOUT, newV.toString());
            config.save();
        });

        getEnableDebugProperty().addListener(
                (ov, oldV, newV) -> {
                    config.setProperty(KEY_ENABLE_DEBUG, newV.toString());
                    config.save();
                });

        getDisableExperimentalWarningDialogProperty().addListener(
                (ov, oldV, newV) -> {
                    config.setProperty(
                            KEY_DISABLE_EXPERIMENTAL_BUILD_WARNING_DIALOG,
                            newV.toString());
                    config.save();
                });

        getStartMinimizedProperty().addListener(
                (ov, oldV, newV) -> {
                    config.setProperty(
                            KEY_START_MINIMIZED,
                            newV.toString());
                    config.save();
                });
    }

    public void loadConfig() {

        String enableDebugOutputCbState
                = config.getProperty(KEY_ENABLE_DEBUG).
                        orElse("" + getEnableDebugProperty().get());
        getEnableDebugProperty().set(Boolean.valueOf(enableDebugOutputCbState));

        String discoveryTimeoutTfState
                = config.getProperty(KEY_DISCOVERY_TIMEOUT).
                        orElse("" + getDiscoveryTimeoutProperty().get());
        getDiscoveryTimeoutProperty().set(Long.valueOf(discoveryTimeoutTfState));

        String disableExperimentalWarningDialogState
                = config.getProperty(KEY_DISABLE_EXPERIMENTAL_BUILD_WARNING_DIALOG).
                        orElse("" + getDisableExperimentalWarningDialogProperty().get());
        getDisableExperimentalWarningDialogProperty().set(Boolean.valueOf(
                disableExperimentalWarningDialogState));

        String startMinimizedState
                = config.getProperty(KEY_START_MINIMIZED).
                        orElse("" + getStartMinimizedProperty().get());
        getStartMinimizedProperty().set(Boolean.valueOf(
                startMinimizedState));
    }

    public BooleanProperty getStartMinimizedProperty() {
        return startMinimizedProperty;
    }

    public BooleanProperty getDisableExperimentalWarningDialogProperty() {
        return disableExperimentalWarningDialogProperty;
    }

    /**
     * @return the discoveryTimeoutProperty
     */
    public LongProperty getDiscoveryTimeoutProperty() {
        return discoveryTimeoutProperty;
    }

    /**
     * @return the enableDebugProperty
     */
    public BooleanProperty getEnableDebugProperty() {
        return enableDebugProperty;
    }

}
