/* 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 20015–2018 by Michael Hoffer
 * 
 * This file is part of SonoAir.
 *
 * SonoAir is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3
 * as published by the Free Software Foundation.
 * 
 * see: http://opensource.org/licenses/GPL-3.0
 *
 * VRL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This version of SonoAir includes copyright notice and attribution requirements.
 * According to the GPL this information must be displayed even if you modify
 * the source code of SonoAir. Neither the SonoAir attribution icon(s) nor any
 * copyright statement/attribution may be removed.
 */
package eu.mihosoft.sonoair;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.LongStringConverter;

/**
 * FXML Preference Controller class.
 *
 * @author Michael Hoffer &lt;info@michaelhoffer.de&gt;
 */
public class PreferencesController implements Initializable {

    private ConfigController configController;

    public PreferencesController() {
        //
    }

    /**
     * Initializes the controller class.
     *
     * @param url
     * @param rb
     */
    @Override
    public void initialize(URL url, ResourceBundle rb) {

        setupTextFields();

    }

    public void setConfigController(ConfigController configController) {
        this.configController = configController;
        
        StringConverter<? extends Number> converter = new LongStringConverter();
        timeoutTf.textProperty().bindBidirectional(
                configController.getDiscoveryTimeoutProperty(),
                (StringConverter<Number>)converter);
        enableDebugOutputCb.selectedProperty().bindBidirectional(
                configController.getEnableDebugProperty());
        disableExperimentalWarningDialogCb.selectedProperty().bindBidirectional(
                configController.getDisableExperimentalWarningDialogProperty());
        startMinimizedCb.selectedProperty().
                bindBidirectional(configController.getStartMinimizedProperty());
    }

    @FXML
    TextField timeoutTf;

    @FXML
    CheckBox enableDebugOutputCb;
    
    @FXML
    CheckBox disableExperimentalWarningDialogCb;
    
    @FXML
    CheckBox startMinimizedCb;

    private void setupTextFields() {
        timeoutTf.textProperty().addListener(
                (ov, oldV, newV) -> {
                    boolean isDigit = true;

                    boolean invalid = false;

                    for (int i = 0; i < newV.length(); i++) {
                        char ch = newV.charAt(i);
                        isDigit = ch >= '0' && ch <= '9';

                        if (!isDigit) {
                            invalid = true;
                        }
                    }

                    if (invalid) {
                        timeoutTf.setText(oldV);
                    } else if (newV.length() > 5 /*max-text-length*/) {
                        timeoutTf.setText(newV.substring(0, 5 /*max-text-length*/));
                    }
                });

        timeoutTf.addEventFilter(KeyEvent.KEY_TYPED, new EventHandler<KeyEvent>() {
            private String numericLastKey;

            @Override
            public void handle(KeyEvent event) {

                char ar[] = event.getCharacter().toCharArray();
                char ch = ar[ar.length - 1];

                boolean isDigit = ch >= '0' && ch <= '9';

                /*populating lastkey if it is numeric*/
                if (isDigit) {
                    numericLastKey = String.valueOf(ch);
                }

                if (isValid()) {
                    /* Disable other charater than numeric character. */
                    if (!isDigit) {
                        event.consume();
                    }
                } else {
                    event.consume();
                }
            }

            /**
             * Check for valid text or not.
             *
             * @return boolean if not valid then return false else true.
             */
            private boolean isValid() {

                if (timeoutTf.getText().isEmpty()) {
                    return true;
                }
                try {
                    String testText = timeoutTf.getText();
                    testText = (numericLastKey != null
                            && !numericLastKey.isEmpty()) ? testText + numericLastKey : testText;
                    numericLastKey = "";
                    Integer.parseInt(testText);
                } catch (NumberFormatException ex) {
                    return false;
                }
                return true;
            }
        });
    }
}
