/* 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 20015–2018 by Michael Hoffer
 * 
 * This file is part of SonoAir.
 *
 * SonoAir is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3
 * as published by the Free Software Foundation.
 * 
 * see: http://opensource.org/licenses/GPL-3.0
 *
 * VRL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This version of SonoAir includes copyright notice and attribution requirements.
 * According to the GPL this information must be displayed even if you modify
 * the source code of SonoAir. Neither the SonoAir attribution icon(s) nor any
 * copyright statement/attribution may be removed.
 */
package eu.mihosoft.sonoair;

import eu.mihosoft.upnp.sonos.ZoneGroup;

/**
 *
 * @author Michael Hoffer &lt;info@michaelhoffer.de&gt;
 */
class ZoneGroupWrapper {

    private final ZoneGroup group;
    private final String devName;

    public ZoneGroupWrapper(ZoneGroup group) {
        this.group = group;
        this.devName = "";
    }

    public ZoneGroupWrapper(String devName) {
        this.group = null;
        this.devName = devName;
    }

    public ZoneGroup getGroup() {
        return group;
    }

    @Override
    public String toString() {

        String grp = "";

        if (group != null) {

            if (group.isGroup()) {
                grp = " (Group)";
            }
            
            

            if (group.getName() != null) {
                return group.getName() + grp;
            } else {
                return "Warning: name not available" + grp;
            }

        } else {
            return devName;
        }
    }
}
